package SDB::Common::BuiltIn;

use strict;
use warnings;

our $instance = undef;

=item get_instance()
Trying to implement the singleton pattern.
=cut

sub get_instance {
    if( !defined $instance ) {
        my $class = shift;
        $instance = {};
        bless $instance, $class;
    }

    return $instance;
};

=pod
Maintain alphabetical order of the methods.
=cut

sub getgrgid {
    my $self = shift;
    if( wantarray ) {
        return CORE::getgrgid($_[0]);
    }
    my $retval = CORE::getgrgid($_[0]);
    return $retval;
};

sub getgrnam {
    my $self = shift;
    if( wantarray ) {
        return CORE::getgrnam($_[0]);
    }
    my $retval = CORE::getgrnam($_[0]);
    return $retval;
};

sub getpwuid {
    my $self = shift;
    if( wantarray ) {
        return CORE::getpwuid($_[0]);
    }
    my $retval = CORE::getpwuid($_[0]);
    return $retval;
};

sub print{
   my $self = shift;
   return CORE::print($_[0]);
}

sub rename {
    my ($self, $oldPath, $newPath) = @_;
    return CORE::rename($oldPath, $newPath);
};

1;

