package SDB::Install::App::Console::DeleteXSADirectories;
use base SDB::Install::App::Console;

use File::Spec;
use SDB::Install::Configuration::HdbModify;
use SDB::Install::System qw (deltree);
use SDB::Install::Globals qw($gProductNameXS2);
use SDB::Install::MsgLst;
use Getopt::Long;
use strict;

sub new {
    my $self = shift->SUPER::new ();
    return $self;
}

sub InitApp{
    my ($self) = @_;
    $self->SUPER::InitApp();
    return 1;
}

sub getProgramName {
    return 'hdbmodify';
}

sub CleanUp{
    my ($self) = @_;

    my $instconfig = $self->getInstconfig();
    my $sapSystem     = (defined $instconfig) ? $instconfig->getSAPSystem()
                                           : undef;
    if (defined $sapSystem) {
        # now added trace directories exist
        $self->addLogToTraceDir($sapSystem,
                                $self->{ModifyName},
                                $instconfig->isCheckOnly());
    }
    $self->SUPER::CleanUp();
}

sub InitCmdLineArgs{
    my ($self,$args) = @_;
    $self->{instconfig} = SDB::Install::Configuration::HdbModify->new($self->{options}, $self->{configfile});

    $self->{action}            = "Clearing $gProductNameXS2 directories";
    $self->{actionProgressive} = "Clearing $gProductNameXS2 directories";
    $self->{actionDone}        = "$gProductNameXS2 directories cleared";

    return $self->SUPER::InitCmdLineArgs ($args);
}

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}

sub mainFunction {
    my ($app, $args) = @_;

    my $rc;
    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();
    eval {

        if (!defined $app->InitCmdLineArgs ($args)){
           return undef;
        }

        if (defined $app->{return}){
            LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
            return $app->{return};
        }

        $rc = $app->init();
    };

    if (defined $app->{return}){
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        return $app->{return};
    }

    $rc = $app->handleReturnCodes($@, $rc);

    $app->CleanUp();
    undef $app;

    return defined $rc ? 0 : 1;
}

sub init{
    my ($self) = @_;

    my $instconfig     = $self->getInstconfig();
    $self->{ModifyName}= $self->getProgramName();

    $instconfig->CheckParams($self->{batch_mode});

    my $msg = $self->getMsgLst()->addProgressMessage("Clearing $gProductNameXS2 directories on local host");
    my $subMsgLst = $msg->getSubMsgLst();

    my $sapSystem   = SDB::Install::SAPSystem->new();
    my $usrSapSid = File::Spec->catfile($instconfig->getValue('Target'), $instconfig->getValue('SID'));
    $sapSystem->initSAPSystem($usrSapSid);

    if (!defined $sapSystem) {
        $subMsgLst->addProgressMessage("Could not initalize SAP System object using path '$usrSapSid'");
        return 1;
    }

    $self->_tryDeleteXsaApplicationsPersistency($sapSystem, $subMsgLst);
    my $globalSidDirectory = $sapSystem->get_globalSidDir() || $sapSystem->getUsrSapSid();
    my $xsDir = File::Spec->catdir(($globalSidDirectory, 'xs'));
    return 1 if (! $self->_deleteDir($xsDir, $subMsgLst));

    $self->_tryDeleteXsaAppWorkingDir($instconfig, $subMsgLst);
    return 0;
}

sub _tryDeleteXsaAppWorkingDir {
    my ($self, $instconfig, $msglst) = @_;
    my $instance = $instconfig->getOwnInstance();
    return if (!defined $instance);
    my $xsaAppWorkingDir = $instance->getXSEADataPath();
    $self->_deleteDir($xsaAppWorkingDir, $msglst);
}

sub _tryDeleteXsaApplicationsPersistency {
    my ($self, $sapSystem, $msglst) = @_;
    my $globalSidDirectory = $sapSystem->get_globalSidDir() || $sapSystem->getUsrSapSid();
    my $pendingXml = File::Spec->catdir(($globalSidDirectory, 'pending_xs_components.xml'));
    return if (! -e $pendingXml);
    $msglst->addProgressMessage("Deleting '$pendingXml'");
    if (!unlink($pendingXml)) {
        $msglst->addProgressMessage("Failed to remove '$pendingXml': $!");
    }
}

sub _deleteDir {
    my ($self, $dir, $msglst) = @_;
    return 1 if (!defined $dir || ! -d $dir);
    $msglst->addProgressMessage("Deleting '$dir'");
    my $outputMsgLst = SDB::Install::MsgLst->new();
    if (!deltree($dir, $outputMsgLst)) {
        $msglst->addProgressMessage("Could not delete '$dir'\n" . ${$outputMsgLst->getMsgLstString});
        return undef;
    }
    return 1;
}

1;