#!/usr/bin/perl
#
# This tool checks the local directory of a slave instance


package SDB::Install::App::Console::HdbCheckHost;

use base SDB::Install::App::Console::HdbCheck;
use SAPDB::Install::Hostname qw(hostname);

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}


#-------------------------------------------------------------------------------
# Additional initialization sets isSlave.
#
# Return int retcode

sub additionalInit {
    my ($self) = @_;
    $self->{instconfig}->{isSlave} = 1;
    return $self->SUPER::additionalInit();
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    my ($self, $hanaHostname) = @_;
    my $hostname = $hanaHostname || hostname();

    return "hdbcheck_$hostname";
}


#-------------------------------------------------------------------------------
# Initializes the program and performs several checks.
# Without parameters
# Returns undef in case of an error

sub init {

    my ($self) = @_;

    if(!$self->{batch_mode}){
        $self->setErrorMessage ($self->getProgramName()
                                . ' is not supported in interactive mode');
        return undef;
    }

    return $self->SUPER::init();
}

sub shouldWarnIfCalledStandalone{
    return 0;
}


#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


1;
