package SDB::Install::App::Console::HdbContainer;

use Getopt::Long;

use SDB::Install::Configuration::Container::HdbInitPersistenceConfig;
use SDB::Install::Configuration::Container::HdbInitialStartConfig;
use SDB::Install::Configuration::Container::HdbInitSSFSConfig;
use SDB::Install::Configuration::Container::HdbUpdateContainerConfig;
use SDB::Install::Configuration::Container::HdbCheckContainerConfig;
use SDB::Install::Configuration::Container::HdbActivatePluginsConfig;
use SDB::Install::SAPSystemContainerHelper::InitPersistenceContainerHelper;
use SDB::Install::SAPSystemContainerHelper::InitialStartContainerHelper;
use SDB::Install::SAPSystemContainerHelper::InitSSFSContainerHelper;
use SDB::Install::SAPSystemContainerHelper::UpdateContainerHelper;
use SDB::Install::SAPSystemContainerHelper::CheckSystemRequirementsContainerHelper;
use SDB::Install::SAPSystemContainerHelper::ActivatePluginsContainerHelper;

use SDB::Install::Globals qw ($gProductNameInstaller $gTmpDir);
use SDB::Install::Log;

use base SDB::Install::App::Console;

use strict;

sub new {
    my $self = shift->SUPER::new();
    return $self;
}

sub InitCmdLineArgs{
    my ($self, $args) = @_;

    my $action;
    GetOptions ('action=s' => \$action);

    if(!$self->_InitCmdLineArgs_aux($action)) {
        return undef;
    }

    return $self->SUPER::InitCmdLineArgs ($args);
}

sub _InitCmdLineArgs_aux{
    my ($self, $action) = @_;

    if  ($action eq "init_persistence") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbInitPersistenceConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::InitPersistenceContainerHelper();
    } elsif  ($action eq "initial_start") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbInitialStartConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::InitialStartContainerHelper();
    } elsif  ($action eq "init_ssfs") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbInitSSFSConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::InitSSFSContainerHelper();
    } elsif  ($action eq "update_container") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbUpdateContainerConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::UpdateContainerHelper();
    } elsif  ($action eq "check_container") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbCheckContainerConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::CheckSystemRequirementsContainerHelper();
    } elsif  ($action eq "activate_plugins") {
        $self->{instconfig} = new SDB::Install::Configuration::Container::HdbActivatePluginsConfig($self->{options});
        $self->{containerHelper} = new SDB::Install::SAPSystemContainerHelper::ActivatePluginsContainerHelper();
    } else {
        return undef;
    }

    return 1;
}

sub init {
    my ($self) = @_;

    my $msglst = $self->getMsgLst ();
    my $caption = "$gProductNameInstaller - HdbContainer " .$self->GetInstaller->{version};
    $msglst->addProgressMessage ("\n\n".$caption . "\n" . ('*' x length ($caption)) . "\n\n");

    my $instconfig = $self->getInstconfig();
    my $rc = $instconfig->CheckParams(1);
    if (!$rc) {
        $self->setErrorMessage ('Configuration error:', $instconfig->getErrMsgLst());
        return undef;
    }

    my $action = $instconfig->getValue("Action");
    my $logFilename = "HdbContainer_$action"."_LOGDATETIME.log";
    $self->{log}->addLogFileLocation(LOG_FORMAT_PLAIN,   $gTmpDir, 1, $logFilename, LOG_INDICATE_LOCATION_ON_STDOUT,
                                     undef, undef, undef, undef, $ENV{HDBLCM_LOGDIR_COPY});

    if ($action eq "init_persistence") {
        $msglst->addProgressMessage ("Initializing persistence...");
        $rc = $self->initPersistence();
    } elsif ($action eq "initial_start") {
        $msglst->addProgressMessage ("Initial start of the container...");
        $rc = $self->initialStart();
    } elsif ($action eq "init_ssfs") {
        $msglst->addProgressMessage ("Initializing SSFS...");
        $rc = $self->initSSFS();
    } elsif ($action eq "update_container") {
        $msglst->addProgressMessage ("Updating container...");
        $rc = $self->updateContainer();
    } elsif ($action eq "check_container") {
        $msglst->addProgressMessage ("Checking container...");
        $rc = $self->checkContainer();
    } elsif ($action eq "activate_plugins") {
        $msglst->addProgressMessage ("Activating plugins...");
        $rc = $self->activatePlugins();
    } else {
        return undef;
    }

    return $rc;
}

sub _getContainerHelper {
    my ($self) = @_;
    return $self->{containerHelper};
}

sub initPersistence {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    my $sysinfo = $self->GetSysInfo();
    my $rc = $containerHelper->initPersistence($instconfig, $sapSys, $sysinfo);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot initialize persistence", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}

sub initialStart {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    my $rc = $containerHelper->initialStart($instconfig, $sapSys);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot start container", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}

sub initSSFS {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    #TODO: Adjust method call below
    my $rc = $containerHelper->initSSFS($instconfig, $sapSys);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot initialize SSFS", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}


sub updateContainer {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    my $rc = $containerHelper->updateContainer($instconfig, $sapSys);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot update container", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}

sub checkContainer {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    my $rc = $containerHelper->checkSystemRequirements($instconfig, $sapSys);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot check container", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}

sub activatePlugins {
    my ($self) = @_;
    my $containerHelper = $self->_getContainerHelper();
    my $msglst = $self->getMsgLst ();
    $containerHelper->setMsgLstContext([$msglst]);
    my $instconfig = $self->getInstconfig();
    my $sapSys = $instconfig->getSAPSystem();
    my $rc = $containerHelper->activatePlugins($instconfig, $sapSys);
    if (! defined $rc) {
        $self->setErrorMessage ("Cannot activate plugins", $containerHelper->getErrMsgLst());
        return undef;
    }
    return $rc;
}

sub main{
    my $app = new __PACKAGE__;

    my $rc;
    eval{

        if (!defined $app->InitCmdLineArgs (\@_)){
           return undef;
        }

        if (defined $app->{return}){
            LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
            return $app->{return};
        }

        $rc = $app->init ();

    };

    if (defined $app->{return}){
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        return $app->{return};
    }

    $rc = $app->handleReturnCodes($@, $rc);

    $app->CleanUp ();

    undef $app;

    return defined $rc ? 0 : 1;
}

1;
