#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 
#

package SDB::Install::App::Gui::Uninstallation;

use SDB::Install::App::Gui;
use SDB::Install::Globals qw ($gProductNameInstaller);
use SDB::Install::Installation;
use Getopt::Long;
use SDB::Install::Gui::Frame::StartUninstallation;
use SDB::Install::Configuration::Uninstallation;
use strict;

use Wx qw(
    wxDEFAULT
    wxSYSTEM_MENU
    wxCAPTION
    wxCLOSE_BOX 
    wxCLIP_CHILDREN
    );

our @ISA = qw (SDB::Install::App::Gui);


sub new{
    return shift->SUPER::new ();
}


sub InitCmdLineArgs{
	my ($self,$args) = @_;
	
    my $instconfig = new SDB::Install::Configuration::Uninstallation
        ($self->{options}, $self->{configfile});

    $self->{instconfig} = $instconfig;

	my $rc = $self->SUPER::InitCmdLineArgs ($args,1);
	
    if (!defined $rc){
        return undef;
    }

    local @ARGV = @$rc;

	$self->{options} = {};

    if  (!defined $self->getOptions (
            {
                'path=s' => \$self->{options}->{path},
                'i=s' => \$self->{options}->{i},
                'no_globals' => \$self->{options}->{no_globals},
                'all' => \$self->{options}->{all},
                'kill_running_processes' => \$self->{options}->{kill_running_processes}
            },
            0
		)){
		$self->{return} = -1;
        return undef;
	}
    if (!defined $self->init ()){
        return undef;
    }
    return \@ARGV;
}


#-------------------------------------------------------------------------------
# Returns a reference to an array containing hdbuninst options
# without help/info options.

sub GetSwitches{
	return ['-i <installation name>', '-path <installation path>'];
}

#-------------------------------------------------------------------------------
# Returns a reference to an array of arrays containg the description
# of hdbuninst options without common help options.

sub GetUsage{
	
	return [['-i <installation name>', undef, 'Select installation by name'],
            ['-path <directory>',      undef, 'Select by installation path']];
}


sub getFrameWindow{
    my ($self) = @_;

    return SDB::Install::Gui::Frame::StartUninstallation->new(undef, -1, '',
                                                              [100, 100],
                                                              [200, 100],
                                                            );
}



#-------------------------------------------------------------------------------
sub init{
    my ($self) = @_;

    if (!$self->defineLog('uninstall', 'hdbuninst')) {
        return undef;
    }

    if ($self->{options}->{path}){
        $self->{installation} = new SDB::Install::Installation ($self->{options}->{path});
        if (!defined $self->{installation}->getManifest ()){
            $self->setErrorMessage ("No installation found in path '$self->{options}->{path}'");
            return undef;
        }
        $self->{installation}->GenPackageList();
        $self->{installation}->SelectAllPackages();
    }

    if ($self->{installation}->isa ('SDB::Install::Installation::Generic')){
        require SDB::Install::Configuration::GenericUninstallation;
        bless ($self->{instconfig}, 'SDB::Install::Configuration::GenericUninstallation');
        $self->{instconfig}->setInstallation ($self->{installation});
        $self->{instconfig}->setMsgLstContext([$self->getMsgLst()]);
        $self->{instconfig}->parseInstallParamsXml ();
        my $customConfigurationClass = $self->{instconfig}->getCustomConfigurationClass ();
        if (defined $customConfigurationClass){
            local @INC = @INC;
            push @INC, $self->{installation}->getCustomModulesDir();
            eval ("require $customConfigurationClass;");
            if ($@){
                $self->setErrorMessage ("Configuration class '$customConfigurationClass' not implemented: " . $@);
                return undef;
            }
            bless ($self->{instconfig},$customConfigurationClass);
        }
    }

    #
    #   Create Frame
    #
    
    my $title = $self->{installation}->getProductName () . " - Uninstallation";
    $self->GetTopWindow ()->SetTitle ($title);
	return 1;
}

sub CleanUp{
    my ($self) = @_;
    if(defined $self->{installation}) {
        $self->{installation}->setMsgLstContext ([$self->getMsgLst()]);
        $self->{installation}->FreePackages();
        delete $self->{installation};
    }
    $self->SUPER::CleanUp;
}

#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    my $rc;
    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();
    eval{
        my @copy = @_;
        $rc = $app->InitCmdLineArgs (\@copy);
        if (!defined $rc){
           return undef;
        }
        if (defined $app->{return}){
            return $app->{return};
        }
       $app->startMainLoop ();
    };

    if (defined $app->{return}){
        return $app->{return};
    }

    $rc = $app->handleReturnCodes($@, $rc);

    $app->CleanUp ();

    undef $app;

    return defined $rc ? 0 : 1;
}
1;

