package SDB::Install::Base;
use SDB::Install::MsgLst ();
use strict;

sub new{
    return bless (
    {'msglst' => undef, # SDB::Install::MsgLst for tracing
    'errlst' => undef}, # SDB::Install::MsgLst for error handling 
    shift);
}

#
# returns true if there is any error
#

sub errorState{
    if (defined $_[0]->{errlst} && !$_[0]->{errlst}->isEmpty()){
        return 1;
    }
    return 0;
}


#
# reset error context
#

sub resetError{
    if (defined $_[0]->{errlst}){
        $_[0]->{errlst} = new SDB::Install::MsgLst ();
        return 1;
    }
}

#
# reset trace messages
#

sub resetMsgLst{
    if (defined $_[0]->{msglst}){
        my $progressHandler = $_[0]->{msglst}->getProgressHandler ();
        $_[0]->{msglst} = new SDB::Install::MsgLst ();
        if (defined $progressHandler){
            $_[0]->{msglst}->setProgressHandler ($progressHandler);
        }
        return 1;
    }
}

#
# reset trace messages and error messages context
# 

sub resetMsgLstContext{
    my $oldContext = [$_[0]->getMsgLst (), $_[0]->getErrMsgLst ()];
    $_[0]->resetError ();
    $_[0]->resetMsgLst ();
    return $oldContext;
}

sub setMsgLstContext{
    my ($self,$context, $keepProgressHandler) = @_;
    my $oldContext = [$self->getMsgLst (),$self->getErrMsgLst ()];
    if (defined $context){
        if (defined $context->[0]){
            $self->{msglst} = $context->[0];
            if ($keepProgressHandler){
                $context->[0]->setProgressHandler ($oldContext->[0]->getProgressHandler());
            }
        }
        if (defined $context->[1]){
            $self->{errlst} = $context->[1];
        }
    }
    return $oldContext;
}

sub getMsgLstContext{
    my ($self) = @_;
    return [$self->getMsgLst (),$self->getErrMsgLst ()];
}


sub setErrorMessage{
    my ($self, $text, $sublst, $level) = @_;
    if (!defined $level){
        $level = 3;
    }
    my $errlst = $self->getErrMsgLst ();
    if (defined $sublst && $sublst == $errlst){
        $sublst  = new SDB::Install::MsgLst ();
        $sublst->setMsgLst ($errlst);
    }
    $errlst->initMsgLst ();
    my $errmsg = $errlst->addError ($text, $sublst, $level);
    if (!defined $errmsg){
        return undef;
    }
    #append error to msglst as well
    my $msg = $errmsg->copy();
    $msg->resetSubMsgLst();
    $self->getMsgLst ()->appendMsg ($msg);
    return $errmsg;
}

sub appendErrorMessage{
    my ($self, $text, $sublst, $level) = @_;
    if (!defined $level){
        $level = 3;
    }
    my $errlst = $self->getErrMsgLst ();
    my $msg = $errlst->addError ($text, $sublst, $level);
    if (!defined $msg){
        return undef;
    }
    #append error to msglst as well
    $msg = $msg->copy();
    $msg->resetSubMsgLst();
    return  $self->getMsgLst ()->appendMsg ($msg);
}


sub getErrorString{
    if (defined $_[0]->{errlst}){
        my $errString = ${shift->{errlst}->getMsgLstString(@_)};
        {
            local $/ = "\r\n";
            chomp ($errString);
            $/ = "\n";
            chomp ($errString);
        }
        return $errString;
    }
    return '';
}

sub getMsgLst{
    my ($self) = @_;
    if (!defined $self->{msglst}){
        $self->{msglst} = new SDB::Install::MsgLst ();
    }
    return $self->{msglst};
}

sub getErrMsgLst{
    my ($self) = @_;
    if (!defined $self->{errlst}){
        $self->{errlst} = new SDB::Install::MsgLst ();
    }
    return $self->{errlst};
}

sub DESTROY{
}

1;

