package SDB::Install::Configuration::Container::HdbCheckContainerConfig;

use base SDB::Install::Configuration::Container::HdbContainerConfig;

use strict;

sub new {
    my $self = shift->SUPER::new (@_);

    my $section = 'HdbContainer';
    my $order   = 0;

    $self->{params} = {
        'Action'    => $self->getParamAction($order++, $section),
        'SID'       => $self->getParamSID($order++, $section),
        'RAM'       => $self->getParamRAM($order++, $section),
        'FailOn'    => $self->getParamFailOn($order++, $section),
    };

    return $self;
}

sub getParamFailOn {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order,
        'opt'                         => 'fail_on',
        'opt_arg'                     => 'all|<check1>[,<check2>]...',
        'type'                        => 'csv',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Fail on',
        'desc'                        => 'Ckecks to fail on',
        'mandatory'                   => 0,
        'valid_values'                => ['all', 'none', 'kernel.shmmax', 'kernel.shmni', 'kernel.shmall', 'fs.file-max', 'fs.aio-max-nr', 'vm.memory_failure_early_kill',
                                          'vm.max_map_count', 'net.ipv4.ip_local_port_range', 'ulimit.nofile', 'ulimit.stack' ]
    );

    return \%param;
}

1;
