package SDB::Install::Configuration::OptionTimeout;

use strict;

use base 'SDB::Install::Configuration::OptionWithArgs';

our $TIMEOUT_OPTION    = 'timeouts';
our $TIMEOUT_GETOPT_SPEC    = "$TIMEOUT_OPTION=s";
our $TIMEOUT_SYNTAX    = "--$TIMEOUT_OPTION=<name1>:<sec>[,<name2>:<sec>]...";
our $TIMEOUT_ENV_VARIABLE    = 'HDB_INSTALLER_TIMEOUT_LIST';
our $TIMEOUT_DESCRIPTION_TEMPLATE    = 'Sets customized timeouts (%s)';

sub getSyntax{
    return $TIMEOUT_SYNTAX;
}

sub getDescriptionTemplate{
    return $TIMEOUT_DESCRIPTION_TEMPLATE;
}

sub getGetOptionSpec{
    return $TIMEOUT_GETOPT_SPEC;
}

sub getOptionName{
    return $TIMEOUT_OPTION;
}

sub getEnvValue{
    return $ENV{$TIMEOUT_ENV_VARIABLE};
}

sub getEnvironmentVariableName{
    return $TIMEOUT_ENV_VARIABLE;
}

sub parseArg{
    my ($self, $arg, $ignoreError,$context) = @_;
    my ($argKey, $argValue) = ($arg =~ /(.+):(.+)/);
    my $rcError = undef;
    my $errStr = "Parsing '$context' failed:";
    if (!$argKey || !$argValue){
        $errStr .= " Cannot parse argument '$arg'";
        return $self->handleError ($errStr, $ignoreError);
    }

    if (!$self->keyIsValid ($argKey)){
        $errStr .= " Unknown argument '$argKey'";
        return $self->handleError ($errStr, $ignoreError);
    }

    if ($argValue !~ /^\d+$/){
        $errStr .= " Value of argument '$argKey' has to be a positive integer";
        return $self->handleError ($errStr, $ignoreError);
    }
    $self->{_args}->{$argKey} = $argValue;
    return 1;
}

sub getArgumentString{
    my ($self, $argKey) = @_;
    if (defined $self->{_args}->{$argKey}){
        return "$argKey:$self->{_args}->{$argKey}";
    }
    return undef;
}


1;
