package SDB::Install::Configuration::OptionWithArgs;

use strict;
use base 'SDB::Install::Base';

sub new {
    my $self = shift->SUPER::new ();
    ($self->{_keyList}, $self->{_hiddenKeyList}) = @_;
    return $self;
}

sub isHidden{
    return !defined $_[0]->{_keyList} || !@{$_[0]->{_keyList}};
}


sub handleError{
    my ($self,$errStr, $ignoreError) = @_;
    if ($ignoreError){
        $self->getMsgLst ()->addWarning ($errStr);
        return 1;
    }
    else{
        $self->appendErrorMessage ($errStr);
        return undef;
    }
}


sub parseArg{
    my ($self, $arg, $ignoreError, $context) = @_;
    if ($self->keyIsValid ($arg)){
        $self->{_args}->{$arg} = 1;
    }
    else{
        return $self->handleError ("Parsing '$context' failed: Unknown argument '$arg'", $ignoreError);
    }
    return 1;
}

sub getEnvironmentVariableName{
    return undef;
}


sub getEnvValue{
    return undef;
}

sub parseArgs{
    my ($self, $optionValue) = @_;
    my $rc = 1;
    $self->{_args} = {};
    my $i = 0;
    my @context = ('$'.$self->getEnvironmentVariableName(),
        '--' . $self->getOptionName());

    foreach my $inputString ($self->getEnvValue(), $optionValue){
        if (defined $inputString){
            foreach my $arg (split (',', $inputString)){
                if (!defined $self->parseArg ($arg, $i == 0, $context[$i])){
                    $rc = undef;
                }
            }
        }
        $i++;
    }
    return $rc;
}

sub getSyntax{
    return undef;
}

sub getArgumentSyntax{
    return undef;
}

sub getArg{
    my ($self, $argKey) = @_;
    if (!defined $self->{_args}){
        return undef;
    }
    return $self->{_args}->{$argKey};
}

sub getValidKeys{
    my ($self) = @_;
    my @result;
    if (defined $self->{_keyList}){
        @result =  @{$self->{_keyList}};
    }
    return \@result;
}


sub getHiddenValidKeys{
    my ($self) = @_;
    my @result;
    if (defined $self->{_hiddenKeyList}){
        @result =  @{$self->{_hiddenKeyList}};
    }
    return \@result;
}

sub getAllValidKeys{
    my ($self) = @_;
    my @result;
    if (defined $self->{_keyList}){
        push @result, @{$self->{_keyList}};
    }
    if (defined $self->{_hiddenKeyList}){
        push @result, @{$self->{_hiddenKeyList}};
    }
    return \@result;
}

sub keyIsValid{
    my ($self, $key) = @_;
    foreach my $iKey (@{$self->getAllValidKeys ()}){
        if ($key eq $iKey){
            return 1;
        }
    }
    return 0;
}


#
# get a argument key list of all set arguments, which are known by
# $optionWithArgs as well
#
#

sub getSetKeysValidFor{
    my ($self, $optionWithArgs) = @_;
    if (!defined $optionWithArgs){
        return undef;
    }
    my @result;
    my $theirKeys = $optionWithArgs->getAllValidKeys ();
    if (!defined $self->{_args} || !defined $theirKeys ||!@$theirKeys){
        return \@result;
    }

    foreach my $theirKey (@$theirKeys){
        if (defined $self->{_args}->{$theirKey}){
            push @result, $theirKey;
        }
    }
    return \@result;
}


#
# generate an argument string
# just for internal usage (getOptionStringFromArgList)
#
sub getArgumentString{
    my ($self, $argKey) = @_;
    if (defined $self->{_args}->{$argKey}){
        return $argKey;
    }
    return undef;
}

#
# generates a string to be used as a parameter value
# Parameter: $argKeys array of strings
#

sub getStringFromArgList{
    my ($self,$argKeys) = @_;
    if (!defined $argKeys){
        return undef;
    }
    my $argStr;
    my @argStrings;
    foreach my $argKey (@$argKeys) {
        $argStr = $self->getArgumentString ($argKey);
        if (defined $argStr){
            push @argStrings, $argStr;
        }
    }
    return (@argStrings) ? join (',', @argStrings) : undef;
}


#
# generates an option string to be used in a command line
# Parameter: $argKeys array of strings
#

sub getOptionStringFromArgList{
    my ($self,$argKeys) = @_;

    my $value = $self->getStringFromArgList($argKeys);
    return (defined $value) ? '--' . $self->getOptionName() . '=' . $value
                            : '';
}


sub getDescriptionTemplate{
    return 'Valid arguments: %s';
}

sub getDescription{
    my ($self) = @_;
    return sprintf ($self->getDescriptionTemplate() ,
            join (', ', sort @{$self->getValidKeys()}));
}

sub getLabelTemplate{
    return 'Valid arguments: %s';
}

sub getLabel {
    my ($self) = @_;
    return sprintf ($self->getLabelTemplate() ,
            join (', ', sort @{$self->getValidKeys()}));
}

sub deleteArgument {
	my ($self, $argKey) = @_;
	if (defined $self->{_args}->{$argKey}) {
		delete $self->{_args}->{$argKey};
	}
}

1;

