package SDB::Install::Configuration::ServerUpgradeChecker;

use base SDB::Install::Configuration;
use SDB::Install::Version;

use SDB::Install::Globals qw ($gProductNameEngine);

sub checkMetaDataSeparation{
    my ($self, $sapSys) = @_;

    my $msg = $self->getMsgLst()->addMessage ("Checking metadata separation");
    my $msglst = $msg->getSubMsgLst ();

    my $instance = $sapSys->getNewDBInstances()->[0];
    my $version2 = new SDB::Install::Version (2,0,0,0);
    my $serverManifest = $instance->getManifest();
    if (!defined $serverManifest) {
        my $expectedManfiestPath = $instance->getManifestPath();
        $self->setErrorMessage("Could not detect a valid manifest file of the installed $gProductNameEngine in the expected location '$expectedManfiestPath'.");
        return undef;
    }
    my $hanaVersion = $serverManifest->getVersionObjectWithoutRevChangeList ();
    if (!$version2->isNewerThan ($hanaVersion)){
        # hana version is already >= 2.0
        $msglst->addMessage ("HANA start version is already >= 2.0");
        return 1;
    }

    my $iniFileName     = 'indexserver.ini';
    my $metadataSection = 'metadata';
    my $keyName         = 'enable_metadata_separation';

    if ($instance->isMultiDb()){
        my $mdcMinVersion = new SDB::Install::Version (1,'00',122,'04');
        if ($mdcMinVersion->isNewerThan ($hanaVersion)){
            $self->setErrorMessage ("Upgrade is not possible.");
            $self->appendErrorMessage ("Minimum HANA version for multitenant systems is " . $mdcMinVersion->asString ());
            $self->appendErrorMessage ("For more information, see SAP Note 2372809.");
            return 0;
        }
        $iniFileName = 'nameserver.ini';
    }
    my $layeredCfg = $instance->getLayeredConfig ();
    my $iniFile = $layeredCfg->getIniFile ($iniFileName);

    if (! defined $iniFile){
        $self->setErrorMessage ("Cannot get ini file", $layeredCfg->getErrMsgLst ());
        return undef;
    }
    $msg = $msglst->addMessage ("Reading '$iniFileName'");
    $iniFile->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $iniFile->readValues ()){
        $self->setErrorMessage ("Cannot read layered ini file '$iniFileName'", $iniFile->getErrMsgLst());
        return undef;
    }
    $iniFile->setMsgLstContext ([$msglst]);
    if (!$iniFile->existsValue ($metadataSection, $keyName)){
        $msglst->addMessage ("Key '$metadataSection/$keyName' not found in '$iniFileName'");
        return 1;
    }

    my $value = $iniFile->getValue ($metadataSection, $keyName);

    if (defined $value && $value eq 'false'){
        $self->setErrorMessage ("Upgrade is not possible due to missing metadata separation.");
        $self->appendErrorMessage ("For more information, see SAP Note 2372809.");
        return 0;
    }
    return 1;
}

1;
