package SDB::Install::Configuration::Uninstallation;

use base SDB::Install::Configuration::AnyConfig;
use SDB::Install::RemoteHostctrlHosts;
use SDB::Install::RemoteHosts;
use SDB::Install::Globals qw($gProductNameSystem $gXSParametersGenericConstraint);
use SDB::Install::SysVars qw($isWin $path_separator);
use strict;


our $section = "Uninstallation";

sub new{
    my $self = shift->SUPER::new (@_);
    my $order = 0;
    #$self->{ignore_not_existing} = $_[0]->{ignore_not_existing};
    $self->{params} = {
        'SID'               => $self->getParamSID($order++, $section),
        'PATH'              => $self->getParamPATH              ($order++, $section),
        'SkipHostagentCalls' => $self->getParamSkipHostagentCalls($order++, $section),
        'RemoveUnreachableHost' => $self->getParamRemoveUnreachableHost($order++, $section),
        'Force'             => $self->getParamForce             ($order++, $section),
        'IgnoreNotExisting' => $self->getParamIgnoreNotExisting ($order++, $section),
        'NoExclusive'       => $self->getParamNoExclusive        ($order++, $section),
        'Package'           => $self->getParamPackage           ($order++, $section),
        'ShowPending' => $self->getParamShowPending($order++, $section),
        'KeepUser'    => $self->getParamKeepUser   ($order++, $section),
        (
            !$isWin
            ? (
                 'KeepUserHomeDir' => $self->getParamKeepUserHomeDir($order++, $section),
                 'SkipModifySudoers'   => $self->getParamSkipModifySudoers($order++, $section),
              )
            : ()
        ),
        'KeepXsUsers'      => $self->getParamKeepXsUsers     ($order++, $section, $gXSParametersGenericConstraint),
        'RemoteExecution'  => $self->getParamRemoteExecution ($order++, $section, 1),
        'UseHttp'          => $self->getParamUseHttp         ($order++, $section),
        'Scope'            => $self->getParamScope           ($order++, $section,
                              "Uninstallation of $gProductNameSystem (all hosts) or uninstallation of local instance"),
        'ScopeInteractive' => $self->getParamScopeInteractive($order++, $section,
                              'Automatic uninstallation of remote hosts'),
        ($isWin
            ? ('HostagentUserName' => $self->getParamHostagentUserName($order++, $section)
              )
            : ('InstallSSHKey' => $self->getParamInstallSSHKey($order++, $section),
               'RootUser'      => $self->getParamRootUser     ($order++, $section),
               'RootPassword'  => $self->getParamRootPassword ($order++, $section),
              )
         ),
         'HostagentPassword'=>$self->getParamHostagentPassword($order++,$section),
    };
    $self->setInteractive ('SID', 0);
    $self->setDefault('Scope', 'system');
    $self->{params}->{Scope}->{opt_arg_switch} = 'instance';
    return $self;
}

sub getParamIgnoreNotExisting{
    my ($self, $order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'ignore_not_existing',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'str'               => 'Don\'t treat missing installation as an error.',
        'init_with_default' => 1,
        'set_interactive'   => 0,
    };
}

sub getParamNoExclusive{
    my ($self, $order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'noexclusive',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'str'               => 'Don\'t lock install registry. Required for distributed uninstallation',
        'init_with_default' => 1,
        'set_interactive'   => 0,
        'hidden'            => 1
    };
}

sub getParamPackage{
    my ($self, $order, $section) = @_;

        return {
        'order'             => $order,
        'opt'               => 'package',
        'opt_arg'           => '<name>[,<name>]...',
        'type'              => 'string',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'Selects packages to uninstall',
        'set_interactive'   => 0
    };
}

sub getParamRemoveUnreachableHost{
        my ($self, $order, $section) = @_;
        return {
        'order'             => $order,
        'opt'               => 'remove_unreachable_host',
        'opt_arg'           => '<host name>',
        'type'              => 'string',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'Removes an unreachable remote host from SAP HANA System',
        'set_interactive'   => 0
    };

}

sub InitDefaults{
    my ($self) = @_;
    return 1;
}

sub initInstallation{
    my ($self, $installation) = @_;
    if ($installation->isa ('SDB::Install::SAPSystem')){
        return $self->_initHDBSystem ($installation);
    }
    $self->setSkip ('SID', 1);
    $self->setHidden ('SID', 1);
    $self->setValue ('PATH', $installation->GetInstallationPath ());
    return 1;
}


sub _initHDBSystem{
    my ($self, $system) = @_;
    if ($isWin){
        return 1;
    }

    $self->setValue('SID', $system->get_sid());
    $self->setSkip('PATH', 1);

    my $instance = $system->getNewDBInstances()->[0];
    if (!defined $instance) {
        $self->AddError ("No instance found for system " . $system->get_sid());
        if ($self->getBatchValue ('IgnoreNotExisting')){
            print "No instance found for system " . $system->get_sid() . "\n";
            return 1;
        }
        return 1;
    }

    $self->{ownInstance} = $instance;

    my $remoteHosts = $instance->get_hosts();

    if (@$remoteHosts){
        $self->{_hostlist} = $remoteHosts;
        $self->{_allHosts} = $instance->get_allhosts();

        $self->setSkip('RemoteExecution', 0);

        $self->{parentHostDir} = $instance->{_globalSidDir}
                                   . $path_separator
                                   . 'HDB' . $instance->get_nr();
    }
    return 1;
}



#-------------------------------------------------------------------------------
# Does not collect any information of remote hosts.

sub CollectOtherHostInfos {
    return 1;
}


#-------------------------------------------------------------------------------
# Returns undef (hdbuninst kills the system processes)

sub getTimeoutValues{
    return undef;
}

#-------------------------------------------------------------------------------
# Shows the host names of hosts that has to be uninstalled manually
#
# Parameter: $msglst  SDB::Install::MsgLst # used to write progress messages
#            $showNotFound boolean
#
# Returns int retCode

sub showRemainingHosts {

    my ($self, $msglst, $showAll) = @_;

    my $outstandingHosts = undef;
    my $hostOrHosts      = 'host: ';
    my $parentHostDir    = $self->{parentHostDir};
    my $hostList         = ($showAll) ? $self->{_allHosts}
                                      : $self->{_hostlist};

    if (defined $parentHostDir && (-d $parentHostDir)) {

        foreach my $currHost (sort(@$hostList)) {

            my $currDir = $parentHostDir . $path_separator . $currHost;

            if (-d $currDir) {

                if (defined $outstandingHosts) {
                    $hostOrHosts      = 'hosts: ';
                    $outstandingHosts = "$outstandingHosts $currHost";
                }
                else {
                    $outstandingHosts = $currHost;
                }
            }
        }
    }

    if (defined $outstandingHosts) {

        $msglst->addProgressMessage
            ("Uninstallation of $gProductNameSystem is not yet finished.");

        $msglst->addProgressMessage
             ("    To complete uninstallation, run '"
              . $SAPDB::Install::Config{ProgramName}
              . " --scope=instance' on "
              . $hostOrHosts . $outstandingHosts);
    }
    elsif ($showAll) {
        $msglst->addProgressMessage("Installed remote hosts not found");
    }
    return 1;
}


#-------------------------------------------------------------------------------
# Sets the value 'ssh' or 'saphostagent' for the parameter '--remote_execution'.
#
# A comment at the beginning of AnyConfig shows the correct order of this
# parameter according to the depending parameters.

sub setRemoteExecution {

    my ($self, $value) = @_;

    my $rc = $self->SUPER::setRemoteExecution($value);

    if ($rc) {
        $self->setSkip('Scope',            0);
        $self->setSkip('ScopeInteractive', $self->getBatchValue ('RemoveUnreachableHost'));

        if (defined $self->getBatchValue('RootUser')) {
            $self->setScope('system');
        }
    }

    return $rc;
}

1;
