package SDB::Install::Configuration::XMLPasswdParser;

use SDB::Install::XMLParser;
use SDB::Install::BaseLegacy;
use IO::Handle;
use strict;

our @ISA = qw (SDB::Install::XMLParser SDB::Install::BaseLegacy);

our $tagPasswords = 'Passwords';


sub new{
    my $self = shift->SUPER::new ();
    ($self->{in}) = @_;
    return $self;
}


sub parse{
    my ($self) = @_;
    if (!defined fileno ($self->{in})){
        $self->AddError ('No valid input handle');
        return undef;
    }

    my $inputStream = new IO::Handle ();
    if (!$inputStream->fdopen (fileno ($self->{in}),'r')){
        $self->AddError ("Cannot open file descriptor: $!");
        return undef;
    }

    eval{
        $self->SUPER::parse ($inputStream);
    };

    if ($@){
        $self->AddError ("Error parsing xml input: $@");
        return undef;
    }

    my $node = $self->getElementByTagName ($tagPasswords);

    if (!defined $node){
        $self->AddError ("No '$tagPasswords' tag found in xml");
        return undef;
    }
    return 1;
}

sub getPassword{
    my ($self, $wantedTag, $optionName) = @_;
    if (!defined $self->{root}){
        $self->AddError ("No parse tree");
        return undef;
    }

    my $node = $self->getElementByTagName ($tagPasswords);

    $node = $node->{child};

    while (defined $node){
        if ($node->{type} eq $wantedTag){
            return $node->{content};
        }
        $node = $node->{neighbor};
    }
    $self->AddError ("No password tag '$optionName' found");
    return undef;
}


1;
