package SDB::Install::EsComponentVersion;

use strict;
use parent 'SDB::Install::ComponentVersion';

# As of SPS 12 ES release major was changed from 16 to 1
my $LEGACY_ES_RELEASE_NUMBER = 16;

sub isNewerThan {
	my ($self, $otherVersion) = @_;
	my $ownRelease = $self->_getIntegerDetails()->[0];
	my $otherRelease = $otherVersion->_getIntegerDetails()->[0];

	if($ownRelease == $LEGACY_ES_RELEASE_NUMBER && $otherRelease != $LEGACY_ES_RELEASE_NUMBER){
		return 0;
	} elsif($ownRelease != $LEGACY_ES_RELEASE_NUMBER && $otherRelease == $LEGACY_ES_RELEASE_NUMBER){
		return 1;
	}
	return $self->SUPER::isNewerThan($otherVersion);
}

1;
