#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#

package SDB::Install::Globals;

use strict;

use Exporter;
use SDB::Install::SysVars;
use Config;
use File::Basename;
use SDB::Install::Tools qw (getFilenameTimeStamp);

our @ISA = qw (Exporter);

our @EXPORT = qw (getFlavourProductName
                  getBackupName
                  gPrepareLogPath
                  GetServerNotFoundMessage
                  GetNewerServerAlreadyInstalledMessage
                  GetAllRoles
                  GetHostRoleProperties
                  determineSignedManifestContainingDirectory
                  determineSignedManifestRelativePath
                  determineSignedManifestPath
                  getHostRoleByHumanReadableRole
                  getHumanReadableRoleByHostRole
                  getHumanReadableRolesString
                  getComponentNameByHostRole
                  GetAutoInitializeServicesRolesComponentMap
                  getServiceNameToComponentDirNameMap
                  getXS2ServiceNames
                  $gCockpitSignatureManifestName
                  $gDirNameAccelerator
                  $gDirNameEs
                  $gDirNameRDSync
                  $gDirNameStreaming
                  $gDirNameXS2
                  $gDirNameReferenceData
                  $gDirNameCockpitStack
                  $gDirNameResidentInstaller
                  $gDriveWin
                  $gHostRoleAcceleratorStandby
                  $gHostRoleAcceleratorWorker
                  $gHostRoleEsStandby
                  $gHostRoleEsWorker
                  $gHostRoleStandby
                  $gHostRoleCacheServer
                  $gHostRoleStreaming
                  $gHostRoleRDSync
                  $gHostRoleWorker
                  $gHostRoleXS2Standby
                  $gHostRoleXS2Worker
                  $gLogDir
                  $gLogTime
                  $gMinAllcationLimitGB
                  $gMinMemGB
                  $gNameAccelerator
                  $gOperationClientInstall
                  $gOperationAddHost
                  $gOperationCheckHost
                  $gOperationCollectHostInfo
                  $gOperationCollectInstallerInfo
                  $gOperationHdblcmCollectInstallerInfo
                  $gOperationDBUpgradeHost
                  $gOperationModifyHost
                  $gOperationModifyHostRoles
                  $gOperationRegisterHost
                  $gOperationRemoveHost
                  $gOperationRenameHost
                  $gOperationUninstallInstance
                  $gOperationUnregisterHost
                  $gOptionOptimizedUpdate
                  $gOptionStandardUpdate
                  $gOperationCheckSHAVersion
                  $gOperationDeleteXSADirectories
                  $gPlatform
                  $gProductName
                  $gProductNamePlatform
                  $gProductNameAccelerator
                  $gProductNameClient
                  $gProductNameCockpit
                  $gProductNameEngine
                  $gProductNameReferenceData
                  $gProductNameEs
                  $gProductNameInstaller
                  $gProductNameOfficeClient
                  $gProductNameRDSync
                  $gProductNameStreaming
                  $gProductNameStudio
                  $gProductNameSystem
                  $gProductNameTechnology
                  $gProductNameTenant
                  $gProductNameXS2
                  $gProductNameAFL
                  $gProductNameLCA
                  $gProductNameHLM
                  $gProductNameSDA
                  $gProductNameSHA
                  $gProductNameLSS
                  $gSapmntDirUx
                  $gSapsysGroupIdDefault
                  $gMaxSapsysGroupIDDefault
                  $gSapsysGroupName
                  $gShortProductNameAccelerator
                  $gShortProductNameClient
                  $gShortProductNameCockpit
                  $gShortProductNameEngine
                  $gShortProductNameEs
                  $gShortProductNameInstaller
                  $gShortProductNameStudio
                  $gShortProductNameOfficeClient
                  $gShortProductNameStreaming
                  $gShortProductNameRDSync
                  $gShortProductNameTenant
                  $gShortProductNameXS2
                  $gShortProductNameAFL
                  $gShortProductNameLCA
                  $gShortProductNameHLM
                  $gShortProductNameSDA
                  $gShortProductNameLSS
                  $gFlavourPlatform
                  $gFlavourExpress
                  $gFlavourCockpit
                  $gKeynameEngine
                  $gKeynameClient
                  $gKeynameClientNoCrypto
                  $gKeynameStudio
                  $gKeynameAFL
                  $gKeynameLCA
                  $gKeynameHLM
                  $gKeynameSDA
                  $gKeynameStreaming
                  $gKeynameEs
                  $gKeynameAccelerator
                  $gKeynameRDSync
                  $gKeynameXS
                  $gKeynameXS2       
                  $gKeynameOfficeClient
                  $gKeynameInstaller
                  $gKeynameLMStructure
                  $gKeynameCockpitStack
                  $gKeynameLSS
                  $gSignatureManifestName
                  $gSpecificHostsRolesRegex
                  $gTmpDir
                  $mComponentsRoles
                  $gUpgPhaseOfflineOption
                  $gUpgPhaseOnlineOption
                  $gUpgPhaseOptionPerskey
                  $gUpgPhasePrepareOption
                  $gUpgPhasePrepareOptionAlias
                  $gXSParametersGenericConstraint
                  $gXSParametersConstraint
                  $gXSParametersRenameConstraint
                  $gXSParametersAddHostOrRoleConstraint
                  $gXSParametersRemoveHostOrRolesConstraint
                  $gMandatoryXSComponents
                  $gUseDefaultValue
                  $gXSASystemUserParamId
                  $gXSASystemUserPwdParamId
                  $gXSAOrgManagerUserParamId
                  $gXSAOrgManagerPwdParamId
                  $gXSAProdSpaceDBSystemUserParamId
                  $gXSAProdSpaceDBSystemUserPwdParamId
                  $gFailedSignatureVerificationMessage
                  $gFailedVerificationMessage
                  $gSAPDSignerNotDetectedMessage
                  $gXSAAppsOnlyDetectedMessage
                  $gUpgradeRestrictionsMessage
                  $gSAPLocation
                 );

our $gDriveWin    = 'C:';
our $gSapmntDirUx = '/hana/shared';
our $gSapsysGroupIdDefault = 79;
our $gMaxSapsysGroupIDDefault = 999;
our $gSapsysGroupName      = 'sapsys';
our $gLogDir;
our $gTmpDir;
our $gLogTime;
our $gSAPLocation;


if ($isWin) {
    $gSAPLocation = $gDriveWin.'\usr\sap';
} else {
    $gSAPLocation = '/usr/sap';
}

{
    $gLogTime = time ();
    
    if (exists $ENV{TEMP}){
        $gTmpDir = $ENV{TEMP};
    }
    elsif (exists $ENV{TMP}){
        $gTmpDir = $ENV{TMP};
    }
    else{
        if ($isWin){
            $gTmpDir = '.'; 
        }
        else{
            foreach ('/var/tmp','/tmp'){
                if (-d){
                    $gTmpDir = $_;
                    last;
                }
            }
        }
    }

    unless( $gTmpDir ) {
        die('Cannot determine directory for installation logs');
    }

    $gLogDir = $gTmpDir.$path_separator . 'hdbinstall_'
             . getFilenameTimeStamp($gLogTime);
}

our $prepared = 0;

sub gPrepareLogPath{
    my ($sid,$action,$msglst, $commonLogDir, $isGui) = @_;
    
    my $useCommonLogDir = (defined $commonLogDir && -d $commonLogDir) ? 1 : 0;

    if ($prepared && $isGui && !$useCommonLogDir){
		if (-d $gLogDir && rmdir($gLogDir)){
		    $gLogDir = $gTmpDir.$path_separator . 'hdbinstall_'
		             . getFilenameTimeStamp($gLogTime);
        	$prepared = 0;
		} elsif (defined $msglst){
			$msglst->AddError ("Cannot delete directory '$gLogDir': $!");
		}
    }
    
    return 1 if ($prepared);
    
    if ($useCommonLogDir) {
        $gLogDir  = $commonLogDir;
        $prepared = 1;
    }
    else {
        my $isSidGiven = defined($sid) && length($sid) > 0;
        my $isActionGiven = defined($action) && length($action) > 0;
        my $string = $isSidGiven ? "_$sid" : '';

# Append the PID to the directory name if no SID value is given
        $gLogDir .= $isSidGiven ? '' : "_$$";
        $string .= $isActionGiven ? "_$action" : '';

        if ($string){
            $gLogDir =~ s/hdbinstall_/hdb${string}_/;
        }

        if (mkdir ($gLogDir)){
            $prepared = 1;
        }
        else{
            if (defined $msglst){
                $msglst->AddError ("Cannot create directory '$gLogDir': $!");
            }
            return undef;
        }
    }

    if (!$isWin && !$>){
        my $gid = getgrnam ($gSapsysGroupName);
        if (defined $gid){
            chown (-1, $gid, $gLogDir);
            chmod(0775, $gLogDir);
        } else {
            chmod(0777, $gLogDir);
        }
    }
    chdir ($gLogDir);
    return 1;
}

our $gProductName = 'SAP HANA';
our $gProductNameSHA = 'SAP Host Agent';

our $gProductNamePlatform = "$gProductName Platform";

our $gNameAccelerator             = 'SAP ASE';
our $gShortProductNameAccelerator = "Accelerator for $gNameAccelerator";
our $gShortProductNameAFL         = 'AFL (Misc)',
our $gShortProductNameClient      = 'Client';
our $gShortProductNameEngine      = 'Database';
our $gShortProductNameEs          = 'Dynamic Tiering';
our $gShortProductNameHLM         = 'Lifecycle Manager',
our $gShortProductNameInstaller   = 'HDB Installer';
our $gShortProductNameLCA         = 'LCAPPS',
our $gShortProductNameRDSync      = 'Remote Data Sync';
our $gShortProductNameSDA         = 'Smart Data Access',
our $gShortProductNameStreaming   = 'Streaming Analytics';
our $gShortProductNameStudio      = 'Studio';
our $gShortProductNameTenant      = 'Tenant Database';
our $gShortProductNameXS2         = 'XS Advanced Runtime';
our $gShortProductNameReferenceData	= 'Reference Data';
our $gShortProductNameCockpit     = 'Cockpit';
our $gShortProductNameExpressEdition = 'Express Edition';
our $gShortProductNameLSS         = 'Local Secure Store';

our $gProductNameAccelerator = "$gProductName $gShortProductNameAccelerator";
our $gProductNameAFL         = "$gProductName $gShortProductNameAFL",
our $gProductNameEngine      = "$gProductName $gShortProductNameEngine";
our $gProductNameEs          = "$gProductName $gShortProductNameEs";
our $gProductNameHLM         = "$gProductName $gShortProductNameHLM",
our $gProductNameInstaller   = "$gProductName Lifecycle Management";
our $gProductNameLCA         = "$gProductName $gShortProductNameLCA",
our $gProductNameRDSync      = "$gProductName $gShortProductNameRDSync";
our $gProductNameSDA         = "$gProductName $gShortProductNameSDA";
our $gProductNameStreaming   = "$gProductName $gShortProductNameStreaming";
our $gProductNameStudio      = "$gProductName $gShortProductNameStudio";
our $gProductNameSystem      = "$gProductName System";
our $gProductNameTechnology  = 'SAP in-memory computing';
our $gProductNameTenant      = "$gProductName $gShortProductNameTenant";
our $gProductNameXS2         = "$gProductName $gShortProductNameXS2";
our $gProductNameReferenceData = "$gShortProductNameReferenceData";
our $gProductNameCockpit     = "$gProductName $gShortProductNameCockpit";
our $gProductNameExpressEdition = "$gProductName $gShortProductNameExpressEdition";
our $gProductNameLSS         = "$gProductName $gShortProductNameLSS";

our $gKeynameEngine          = "HDB";
our $gKeynameClient          = "HDB_CLIENT";
our $gKeynameClientNoCrypto  = "HDB_CLIENT_NO_CRYPTO";
our $gKeynameStudio          = "HDB_STUDIO";
our $gKeynameAFL             = "HANA_AFL";
our $gKeynameLCA             = "LCAPPS_HDB";
our $gKeynameHLM             = "SAPHANALM";
our $gKeynameSDA             = "HDB_FEDERATION_DRIVERS";
our $gKeynameStreaming       = "SMART_DATA_STREAM";
our $gKeynameEs              = "DYNAMIC_TIERING";
our $gKeynameAccelerator     = "SAP_HANA_ACCLRATR_FOR_ASE";
our $gKeynameRDSync          = "REMOTE_DATA_SYNC";
our $gKeynameXS              = "XS";
our $gKeynameXS2             = "SAP_EXTENDED_APP_SERVICES";
our $gKeynameOfficeClient    = "HDB_OFFICEDBC";
# this is fake. this keyname does not occur in any physical manifest file,
# especially not in the "installer manifest" (from dir "instruntime"):
our $gKeynameInstaller       = "HDB_INSTALLER";
our $gKeynameLMStructure     = "LMStructure";
our $gKeynameCockpitStack    = "SAP_HANA_COCKPIT";
our $gKeynameLSS             = "LSS";

our $gProductNameClient            = "$gProductNameEngine $gShortProductNameClient";
our $gProductNameOfficeClient      = "$gProductNameClient for MS Excel";
our $gShortProductNameOfficeClient = "$gShortProductNameClient for MS Excel";

our $gFlavourPlatform = 'HDB';
our $gFlavourExpress  = 'HDB_EXPRESS';
our $gFlavourCockpit  = 'HDB_COCKPIT';

our $gDirNameAccelerator = 'ase';
our $gDirNameEs          = 'es';
our $gDirNameStreaming   = 'streaming';
our $gDirNameRDSync      = 'rdsync';
our $gDirNameXS2         = 'xs';
our $gDirNameCockpitStack = 'cockpit';
our $gDirNameReferenceData	= 'refdata';
our $gDirNameResidentInstaller = 'hdblcm';

our $gHostRoleWorker             = 'worker';
our $gHostRoleStandby            = 'standby';
our $gHostRoleCacheServer        = 'cache_server';
our $gHostRoleAcceleratorWorker  = 'ets_worker';
our $gHostRoleAcceleratorStandby = 'ets_standby';
our $gHostRoleEsWorker           = 'extended_storage_worker';
our $gHostRoleEsStandby          = 'extended_storage_standby';
our $gHostRoleStreaming          = 'streaming';
our $gHostRoleRDSync             = 'rdsync';
our $gHostRoleXS2Worker          = 'xs_worker';
our $gHostRoleXS2Standby         = 'xs_standby';

our $gSpecificHostsRolesRegex = "role=($gHostRoleAcceleratorWorker|$gHostRoleAcceleratorStandby|$gHostRoleEsWorker|$gHostRoleEsStandby|$gHostRoleStreaming|$gHostRoleRDSync|$gHostRoleXS2Worker|$gHostRoleXS2Standby)";


our $gOperationClientInstall        = 'HdbClientInstall_v4';
our $gOperationAddHost              = 'HdbAddHost_v10';
our $gOperationCheckHost            = 'HdbCheckHost_v2';
our $gOperationCollectHostInfo      = 'HdbCollectHostInfo_v7';
our $gOperationCollectInstallerInfo = 'HdbCollectInstallerInfo_v7';
our $gOperationHdblcmCollectInstallerInfo = 'HdblcmCollectInstallerInfo_v7';
our $gOperationDBUpgradeHost        = 'HdbDBUpgradeHost_v8';
our $gOperationModifyHost           = 'HdbModifyHost_v4';
our $gOperationModifyHostRoles      = 'HdbModifyHostRoles_v6';
our $gOperationRegisterHost         = 'HdbRegisterHost_v8';
our $gOperationRemoveHost           = 'HdbRemoveHost_v6';
our $gOperationRenameHost           = 'HdbRenameHost_v8';
our $gOperationUninstallInstance    = 'HdbUninstallInstance_v6';
our $gOperationUnregisterHost       = 'HdbUnregisterHost_v6';
our $gOperationCheckSHAVersion      = 'CheckSHAVersion_v1';
our $gOperationDeleteXSADirectories = 'DeleteXSADirectories_v1';

our $mComponentsRoles = {
	$gHostRoleWorker             => $gProductNameEngine,
	$gHostRoleStandby            => $gProductNameEngine,
  $gHostRoleCacheServer        => $gProductNameEngine,
	$gHostRoleAcceleratorWorker  => $gProductNameAccelerator,
	$gHostRoleAcceleratorStandby => $gProductNameAccelerator,
	$gHostRoleEsWorker           => $gProductNameEs,
	$gHostRoleEsStandby          => $gProductNameEs,
	$gHostRoleStreaming          => $gProductNameStreaming,
	$gHostRoleRDSync             => $gProductNameRDSync,
	$gHostRoleXS2Worker          => $gProductNameXS2,
	$gHostRoleXS2Standby         => $gProductNameXS2,
};

our $gXSParametersGenericConstraint = "Valid for systems with $gProductNameXS2 only";
our $gXSParametersConstraint = "Valid for Installation/Update of $gProductNameXS2 only";
our $gXSParametersRenameConstraint = "Valid for Rename of $gProductNameXS2 only";
our $gXSParametersAddHostOrRoleConstraint = "Valid for adding additional $gHostRoleXS2Worker roles or hosts only";
our $gXSParametersRemoveHostOrRolesConstraint = "Valid for removal of $gProductNameXS2 hosts/roles only";
our $gMandatoryXSComponents = ['xsac_services', 'xsac_portal_serv', 'xsac_alm_pi_ui', 'xsac_xsa_cockpit', 'xsac_ui5_sb'];

our $gSignatureManifestName         = 'SIGNATURE.SMF';
our $gCockpitSignatureManifestName  = 'HDBCOCKPIT.SMF';

our $gOptionOptimizedUpdate = 'optimized';
our $gOptionStandardUpdate = 'standard';

our $gUpgPhasePrepareOption      = 'prepare';
our $gUpgPhasePrepareOptionAlias = 'prepare_update';
our $gUpgPhaseOfflineOption      = 'offline';
our $gUpgPhaseOnlineOption       = 'online';
our $gUpgPhaseOptionPerskey      = 'mostRecentUpdatePhase';

our $gUseDefaultValue = "USE_DEFAULT";

our $gXSASystemUserParamId = "SYSTEM_DB_USER";
our $gXSASystemUserPwdParamId = "SYSTEM_DB_USER_PWD";
our $gXSAOrgManagerUserParamId = "ORG_MANAGER_USER";
our $gXSAOrgManagerPwdParamId = "ORG_MANAGER_PWD";
our $gXSAProdSpaceDBSystemUserParamId="PROD_SPACE_DB_SYSTEM_USER";
our $gXSAProdSpaceDBSystemUserPwdParamId="PROD_SPACE_DB_SYSTEM_USER_PWD";

our $gSAPDSignerNotDetectedMessage = "Authenticity of the components cannot be verified. Required component $gProductNameSHA must be installed on the host. \n".
                                     "For more information on how to properly prepare the components and verify their authenticity and integrity see SAP Note 2577617.";
our $gFailedSignatureVerificationMessage = "Any executable code and software artifact, which is not trusted and verified, can destabilize the existing security controls.".
                                           "For more information see SAP Note 2577617. If you have verified the software authenticity by any other means, you can choose to ignore this error and continue.";
our $gFailedVerificationMessage = "You can choose to ignore this error and continue.";

our $gXSAAppsOnlyDetectedMessage = "$gShortProductNameXS2 components can be installed or updated only together with the $gShortProductNameXS2. "
                                 . "To install or update $gShortProductNameXS2 components only use the product installer (\"xs install\") instead.";
our $gUpgradeRestrictionsMessage = "$gProductName Database update is not possible due to upgrade limitations.";

sub GetServerNotFoundMessage {
    my $action = shift();
    my $messageTemplate = "'$gProductNameEngine' Server component is required for %s, but cannot be found in the specified component locations. Specify location which contains $gProductName Database Server.";
    return sprintf($messageTemplate, $action);
}

sub GetNewerServerAlreadyInstalledMessage {
    my ($targetVersion, $sourceVersion) = @_;
    return "The specified location contains $gProductName Database version '$targetVersion' which is older than the current version '$sourceVersion'";
}

sub GetAllRoles {
    my $hostProperties = GetHostRoleProperties();
    my @sortedRoles = sort { $hostProperties->{$a}->{order} <=> $hostProperties->{$b}->{order} } keys(%$hostProperties);
    my @filteredRoles = grep { $_ ne $gHostRoleCacheServer } @sortedRoles;
    return \@filteredRoles;
}

sub GetHostRoleProperties {
    return {
        $gHostRoleWorker =>
            {'order'          => 1,
             'str'            => "$gShortProductNameEngine Worker ($gHostRoleWorker)",
             'desc'           => 'Host is used for database processing',
             'defaultGroup'   => 'default',
             'hasPartition'   => 1,
             'hasWorkerGroup' => 1,
             'isColumnStore'  => 1,
             'isDbRole'       => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleStandby =>
            {'order'          => 2,
             'str'            => "$gShortProductNameEngine Standby ($gHostRoleStandby)",
             'desc'           => 'Host is idle and available for failover of database processing',
             'defaultGroup'   => 'default',
             'hasWorkerGroup' => 1,
             'isStandby'      => 1,
             'isColumnStore'  => 1,
             'isDbRole'       => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleCacheServer =>
            {'order'          => 3,
             'str'            => "$gShortProductNameEngine Cache Server ($gHostRoleCacheServer)",
             'desc'           => 'Host is used as a Cache Server node',
             'defaultGroup'   => 'default',
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isDbRole'       => 1,
             'requiresRestart'=> 0,
            },

        $gHostRoleEsWorker =>
            {'order'          => 4,
             'str'            => "$gShortProductNameEs Worker ($gHostRoleEsWorker)",
             'desc'           => "Host is used for $gShortProductNameEs",
             'defaultGroup'   => 'extended_storage',
             'hasPartition'   => 1,
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isExtendedStorage' => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleEsStandby =>
            {'order'          => 5,
             'str'            => "$gShortProductNameEs Standby ($gHostRoleEsStandby)",
             'desc'           => "Host is idle and available for failover of $gShortProductNameEs",
             'defaultGroup'   => 'extended_storage',
             'hasWorkerGroup' => 1,
             'isStandby'      => 1,
             'removable'      => 1,
             'isExtendedStorage' => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleAcceleratorWorker =>
            {'order'          => 6,
             'str'            => "$gShortProductNameAccelerator Worker ($gHostRoleAcceleratorWorker)",
             'desc'           => "Host is used for the $gShortProductNameAccelerator",
             'defaultGroup'   => 'ets',
             'hasPartition'   => 1,
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isAccelerator'  => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleAcceleratorStandby =>
            {'order'          => 7,
             'str'            => "$gShortProductNameAccelerator Standby ($gHostRoleAcceleratorStandby)",
             'desc'           => "Host is idle and available for failover of the $gShortProductNameAccelerator",
             'defaultGroup'   => 'ets',
             'hasWorkerGroup' => 1,
             'isStandby'      => 1,
             'removable'      => 1,
             'isAccelerator'  => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleStreaming =>
            {'order'          => 8,
             'str'            => "$gShortProductNameStreaming ($gHostRoleStreaming)",
             'desc'           => "Host is used for $gShortProductNameStreaming",
             'defaultGroup'   => 'streaming',
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isStreaming'    => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleRDSync =>
            {'order'          => 9,
             'str'            => "$gShortProductNameRDSync ($gHostRoleRDSync)",
             'desc'           => "Host is used for $gShortProductNameRDSync",
             'defaultGroup'   => 'rdsync',
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isRDSync'       => 1,
             'requiresRestart'=> 1,
            },

        $gHostRoleXS2Worker =>
            {'order'          => 10,
             'str'            => "$gShortProductNameXS2 Worker ($gHostRoleXS2Worker)",
             'desc'           => "Host is used for $gProductNameXS2",
             'defaultGroup'   => 'default',
             'hasWorkerGroup' => 1,
             'removable'      => 1,
             'isXS2'          => 1,
             'requiresRestart'=> 0,
            },

        $gHostRoleXS2Standby =>
            {'order'          => 11,
             'str'            => "$gShortProductNameXS2 Standby ($gHostRoleXS2Standby)",
             'desc'           => "Host is idle and available for failover of $gProductNameXS2",
             'defaultGroup'   => 'default',
             'hasWorkerGroup' => 1,
             'isStandby'      => 1,
             'removable'      => 1,
             'isXS2'          => 1,
             'requiresRestart'=> 0,
            },
    };
}

sub getFlavourProductName {
    my $flavour = shift;
    return $gProductNameEngine if $flavour eq $gFlavourPlatform;
    return $gProductNameExpressEdition if $flavour eq $gFlavourExpress;
    return $gProductNameCockpit if $flavour eq $gFlavourCockpit;
	return undef;
}

sub getHostRoleByHumanReadableRole{
	my $humanReadableRole = shift;
	my $roleProperties = GetHostRoleProperties();
	my $hostRole;
	foreach my $role (keys %$roleProperties) {
       if($roleProperties->{$role}->{str} eq $humanReadableRole){
       	 $hostRole = $role;
       	 last;
       }
    }
    return $hostRole;
}

sub getHumanReadableRoleByHostRole{
	 my $hostRole = shift;
	 my $roleProperties = GetHostRoleProperties();
	 return $roleProperties->{$hostRole}->{str};
}

sub getHumanReadableRolesString {
	my @hostRoles = @_;
	my @humanReadableRoles = map { getHumanReadableRoleByHostRole($_) } @hostRoles;
	return join(', ',@humanReadableRoles);
}

sub getComponentNameByHostRole {
	my $hostRole = shift;
	return $mComponentsRoles->{$hostRole};
}

our $gPlatform;

if ($isWin){
    $gPlatform = 'ntamd64';
}
elsif($isLinux && $isPPC64LE){
    $gPlatform = 'linuxppc64le';
}
elsif($isLinux && $isPPC64){
    $gPlatform = 'linuxppc64';
}
else{
    $gPlatform = 'linuxx86_64';
}


# global allocation limit in GB,
our $gMinAllcationLimitGB = 24;

# run pyhsical mem check with 22 instead of 24 GB because a few hundred MB are not visible
# for the system call, on both Linux and Windows
our $gMinMemGB = $gMinAllcationLimitGB - 2;

sub getTimeStr{
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
    localtime(defined $_ [0] ? $_ [0] : time);
    $mon++;
    $year += 1900;
    return sprintf ("%d%02d_%02d_%02d.%02d.%02d",
            $year, $mon, $mday, $hour, $min, $sec);
}


sub getBackupName{
    my ($filePath, $newPath) = @_;
    my $backupName = '';
    my $basename;
    if ($filePath =~ /$path_separator/){
        ($basename) = ($filePath =~ /$path_separator(.+?)$/);
    }
    else{
        $basename = $filePath;
    }

    my $time_str = getTimeStr ();
    if (defined $newPath){
        return join($path_separator, $newPath, $basename . '_' .
                    $time_str);
    }
    else{
        return $filePath . '_' . $time_str;
    }
}


sub determineSignedManifestContainingDirectory {
	my ($rootDirectory, $fileName) = @_;
	my $targetFileName = defined($fileName) ? $fileName : $gSignatureManifestName;

	return undef if (!defined($rootDirectory));

	for my $dirOffset ('.', '..', "..${path_separator}.."){
		my $filePathCandidate = join($path_separator, ($rootDirectory, $dirOffset, $targetFileName));
		if(-f $filePathCandidate){
			return join($path_separator, ($rootDirectory, $dirOffset)); 
		}
	}
	return $rootDirectory;
}

sub determineSignedManifestPath {
	my ($rootDirectory, $fileName) = @_;
	my $targetFileName = defined($fileName) ? $fileName : $gSignatureManifestName;

	return undef if (!defined($rootDirectory));

	for my $dirOffset ('.', '..', "..${path_separator}.."){
		my $filePathCandidate = join($path_separator, ($rootDirectory, $dirOffset, $targetFileName));
		return $filePathCandidate if(-f $filePathCandidate);
	}
	return join($path_separator, $rootDirectory, $targetFileName);
}

sub determineSignedManifestRelativePath {
	my ($rootDirectory, $fileName) = @_;
	my $targetFileName = defined($fileName) ? $fileName : $gSignatureManifestName;

	return undef if (!defined($rootDirectory));

	for my $dirOffset ('.', '..', "..${path_separator}.."){
		if(-f join($path_separator, ($rootDirectory, $dirOffset, $targetFileName))){
			return $dirOffset;
		}
	}
	return '.';
}

sub GetAutoInitializeServicesRolesComponentMap{
   return {
            $gHostRoleAcceleratorWorker => $gKeynameAccelerator,
            $gHostRoleStreaming => $gKeynameStreaming,
            $gHostRoleRDSync => $gKeynameRDSync,
            $gHostRoleEsWorker => $gKeynameEs
   };
}

sub getServiceNameToComponentDirNameMap{
    return {
        esserver        => $gDirNameEs,
        streamingserver => $gDirNameStreaming,
        etsserver       => $gDirNameAccelerator,
        etbserver       => $gDirNameAccelerator,
        etxserver       => $gDirNameAccelerator,
        rdsyncserver    => $gDirNameRDSync,
        xscontroller    => $gDirNameXS2,
        xsexecagent     => $gDirNameXS2,
        xsuaaserver     => $gDirNameXS2,
    };
}

sub getXS2ServiceNames{
    return ['xsexecagent', 'xscontroller', 'xsuaaserver'];
}
1;
