#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Parameter label appends ':' and a red asterisk if required flag is set

package SDB::Install::Gui::Control::Label;

use Wx qw (
		wxRED
		wxHORIZONTAL
	);

use SDB::Install::Gui::Design;

our @ISA = qw (Wx::PlWindow);

#
# SDB::Install::Gui::Control::Label ($parent,$id,$text,$isRequired,...)
#



sub new{

	my ($class,$parent,$id,$text,$required, @args) = @_; 
	my ($self ) = $class->SUPER::new($parent,$id,@args);
	
	$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);

	my $sizer = new Wx::BoxSizer (wxHORIZONTAL);
	$self->{text} = $text;
	$self->{required} = $required;
	$self->{textctrl} = new Wx::StaticText ($self,-1,$text . ':');
	$self->{textctrl}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	$self->{reqctrl} = new Wx::StaticText ($self,-1,$required ? '*' : '');
	$self->{reqctrl}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	$self->{reqctrl}->SetForegroundColour (wxRED);
	$sizer->Add ($self->{textctrl},0);
	$sizer->Add ($self->{reqctrl},0);
	$sizer->Layout;
	$self->SetSizer ($sizer);
	return $self;
}

sub AcceptsFocus{
	return 0;
}

sub AcceptsFocusFromKeyboard{
	return 0;
}

sub SetLabel {
	my ($self,$text) = @_;
	$self->{text} = $text;
	$self->{textctrl}->SetLabel ($text . ':');
	$self->GetSizer->Layout ();
}

sub GetLabel {
	$_[0]->{text};
}


sub IsRequired{
	$_[0]->{required};	
}


sub SetRequired{
	my ($self,$required) = @_;
	$self->{required} = $required;
	$self->{reqctrl}->SetLabel ($required ? '*' : '');
	$self->GetSizer->Layout ();
}



sub SetFont{
	my ($self,$font) = @_;
	$self->SUPER::SetFont ($font);
	$self->{reqctrl}->SetFont ($font);
	$self->{textctrl}->SetFont ($font);
	$self->GetSizer->Layout ();
}


sub Destroy{
	my ($self) = @_;
	$self->GetSizer->Clear (1);
	$self->SUPER::Destroy;
}


1;