package SDB::Install::Gui::Dialogs::PackageProgressHandler;

use base SDB::Install::ProgressHandler;
use strict;
use SDB::Common::Utils qw( trim );

sub new{
	my $self = shift->SUPER::new;
	($self->{plan}) = @_;
	return $self;
}

sub InitProgress($$$){
	my ($self,$steps,$value) = @_;
	$self->{range} = $steps;
	$self->{value} = $value;
	if ($self->{range}){
		$value = int(100 * $self->{value} / $self->{range});
	}
	else{
		$value = 100;
	}
	$self->{plan}->SetProgress($value);
	Wx::Yield ();	
}

sub SetProgress ($$) {
	my ($self,$msg) = @_;
	unless ($msg =~ /Starting\s(\d|on)|Stopping\s(\d|on)/) {
		$self->{value}++;
	}
	my $value;

	if ($self->{range}){
		$value = int(100 * $self->{value} / $self->{range});
	}
	else{
		$value = 100;
	}

	$self->{plan}->SetProgress($value);
	Wx::Yield ();	
}

sub notifyTaskChanged{
    my ($self, $task) = @_;
    $self->{label}->SetLabel(trim($task->getLastProgressMessage()));
    $self->{plan}->update($task);
    Wx::Yield ();
}

sub addLine ($$);
*addLine = \&SetProgress;

1;