#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Installation summary dialog

package SDB::Install::Gui::Dialogs::Summary;

use Wx qw (
	wxVERTICAL
	wxHORIZONTAL
    wxEXPAND
    wxLEFT
    wxRIGHT
    wxTOP
    wxBOTTOM
	wxALIGN_CENTER
	wxFIXED_MINSIZE
    );

use Wx::Event qw (EVT_SIZE);

use base SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Gui::Design;
use SDB::Install::Globals;
use SDB::Install::Kit;
use SDB::Install::SysVars qw ($path_separator $isWin);
use SDB::Install::DatabaseStudioSummary;
use SAPDB::Install::Resources;
use strict;

our $is_gtk1 = 0; #Wx::wxGTK1 ();

our $resources = new SAPDB::Install::Resources ();
our $images = $resources->getImages (qw(icon/warning.png));

sub new {
	my ($self) = shift->SUPER::new(@_);
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);

    $self->{id} = 'summary';
    $self->{name} = 'Review & Confirm';

	if ($^O =~ /mswin/i){
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new($self,-1,[-1,-1],[-1,-1]);
	}
	else{
		
		#
		#	avoid Gdk warnings
		#
	
		$self->Show(1);
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new($self,-1,[-1,-1],[-1,-1]);
       	$self->Show(0);
	}

    #
    #   Title
    #

    $self->{'titel_big'} = Wx::StaticText->new($self, -1, "Summary");
    $self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);

    #
    #   Warnings
    #

    $self->{'warnings_icon'} = Wx::StaticBitmap->new($self, -1, new Wx::Bitmap ($images->{'icon/warning.png'}));
    $self->{'warnings_text'} = Wx::StaticText->new($self, -1, "");
	$self->{'warnings_text'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);

	$self->{'warnings_icon'}->Show(0);
	$self->{'warnings_text'}->Show(0);

	#
	#   word-wrap $warnings_text at width of window
	#

     my $handler = sub {
         my ($dialog,$evt) = @_;
		 if ($self->{'warnings_text_string'}) {
			$self->{'warnings_text'}->SetLabel($self->{'warnings_text_string'});
			$dialog->{warnings_text}->Wrap (($dialog->GetSizeWH())[0] - 10 - 20 - 20);
		 }
		$dialog->Layout();
     };

     EVT_SIZE($self,$handler);

     my $warning_sizer = new Wx::BoxSizer(wxHORIZONTAL);
     $warning_sizer->Add($self->{'warnings_icon'},0,wxLEFT | wxTOP,20);
     $warning_sizer->AddSpacer(10);
     $warning_sizer->Add($self->{'warnings_text'},0, wxEXPAND | wxTOP | wxALIGN_CENTER,20);


    #
    #   Sizer
    #

	$sizer->Add($warning_sizer,0,wxEXPAND);
    $sizer->Add($self->{'titel_big'},0,wxLEFT | wxTOP | wxBOTTOM,20);
    $sizer->Add($self->{'tree_ctrl'},1,wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM,20);

    $self->SetSizerAndFit($sizer);
    $self->SetAutoLayout(1);
  	return $self;
}



sub init{
	my ($self,$config) = @_;
	$self->GetWizard->SetInstallMode(1,$config->{'mode'} eq 'update' ? '&Upgrade' : undef) ;
	
	my $app = Wx::wxTheApp ();

	my ($sys, $instconfig,$kit) = (
		$app->{sapSystem},
		$app->{instconfig},
		$app->{kit}
	);


	my $warnings = $instconfig->getWarningList();
	if (@$warnings){
		$self->{'warnings_text_string'} = join ("\n\n",@$warnings);
		$self->{'warnings_text'}->SetLabel($self->{'warnings_text_string'});
		$self->{'warnings_icon'}->Show(1);
		$self->{'warnings_text'}->Show(1);
	} else {
		$self->{'warnings_icon'}->Show(0);
		$self->{'warnings_text'}->Show(0);
	}

	my $allpackages = $kit->GetPackages();

	my $step = $instconfig->getStep ();
    if (defined $step){
        $step = int $step;
    }
    else{
        $step = 0;
    }

    if (!$step && $app->{kit}->skipInstallationSteps()){
        $self->GetWizard->SkipDialog ('install');
        if ($kit->isServer()){
            $self->GetWizard->SkipDialog ('restartInstance');
        }
        return {'auto_next' => 1, 'upgrade_skipped' => 1};
    }

    #
    #   Add root node
    #

    my $roottext = "";
    if ($instconfig->isa ('SDB::Install::Configuration::Generic')){
        $roottext = $instconfig->getProductName () . ' Installation';
    }
    elsif ($kit->IsDBStudioDistribution ()) {
    	my $rootNode = SDB::Install::DatabaseStudioSummary::buildRootNode($instconfig);
    	$roottext = $rootNode->{text};
    }
	elsif ($kit->isClient ()){$roottext = "$gProductNameClient Installation";}
    elsif ($kit->isOfficeClient ()){$roottext = $instconfig->getProductName () . ' Installation';}
    elsif ($config->{'mode'} eq 'install') { $roottext = "System Installation"; }
    elsif ($config->{'mode'} eq 'update') { $roottext = "System Upgrade";}

	if ($instconfig->{step} && $instconfig->can ('pers_getstepname')){
		$roottext .= " (Resume at step '" . $instconfig->pers_getstepname () . "')"
	}


    my $node = $self->{'tree_ctrl'}->AddRoot($roottext);
    $self->{tree_ctrl}->SetItemFont ($node, SDBFONT_BoldText) if (!$is_gtk1);
	$self->{tree_ctrl}->SetItemText ($node, $roottext) if (!$is_gtk1);


    #
    #   Add Software stuff
    #


	#
	#   add software name
	#

	my @user_param_ids = $isWin ? () : qw (HomeDir Shell UID GID);
	
    if ($instconfig->isa ('SDB::Install::Configuration::Generic')){
        my $node = $node;
        my $param;
        foreach my $param_id (@{$instconfig->getParamIds ()}){
            next if (grep {$_ eq $param_id} (@user_param_ids, 'Domain'));

            my $str = $instconfig->getSummaryItem($param_id);
            if (defined $str) {
                $self->{'tree_ctrl'}->AppendItem ($node, $str);
            }
        }
        
        my $kitConfigParser = $kit->getConfigParser();
                
        if (defined $kitConfigParser) {
        	
            require SDB::Install::P2Director;
        
            my $p2Call = $kitConfigParser->getP2Call();
        
            if (defined $p2Call && %$p2Call) {
            	
            	my $repository = $p2Call->{Repository};
            	
            	if (!defined $repository) {
                    $repository =
                        $kit->getArchiveDir() . $path_separator . 'repository';
            	}
            	
            	$self->{'tree_ctrl'}->AppendItem ($node,
            	        'Eclipse repository: '.$repository);
            }
        }
    }
	elsif ($kit->isClient () || $kit->isOfficeClient ()){
		my $node = $node;
		my $param;
		foreach my $param_id (@{$instconfig->getParamIds ()}){
			next if (grep {$_ eq $param_id} (@user_param_ids, 'Domain'));
			
			$param = $instconfig->{params}->{$param_id};
			
			if ( $kit->isClient && !$param->{set_interactive}){
			    if($param_id eq 'ODBCDriverName' && defined $instconfig->{params}->{$param_id}->{value}) {
				    # we are a new installation: show driver name.
				    # (empty block for readability)
			    }
			    else {
			        next;
			    }
			}
			my $str = $instconfig->getSummaryItem($param_id);
			if (defined $str) {
				$self->{'tree_ctrl'}->AppendItem ($node, $str);
			}
		}
		#$self->{tree_ctrl}->Expand ($subnode);		
	}
    elsif ($kit->IsDBStudioDistribution () ){
        my $node = $node;
        my $param;
        foreach my $param_id (@{$instconfig->getParamIds ()}){
			my $str = $instconfig->getSummaryItem($param_id);
			if (defined $str) {
				$self->{'tree_ctrl'}->AppendItem ($node, $str);
			}
        }
        my $featuresNode = SDB::Install::DatabaseStudioSummary::buildFeaturesNode($instconfig);
        if ($featuresNode) {
            $self->_addTreeNode($featuresNode, $node);                	
        }        
    }	
	elsif ($config->{'mode'} eq 'install'){
		if (defined $instconfig){
			my $node = $node;
			my $param_id = 'SID';
			my $param = $instconfig->{params}->{$param_id};
			my $subnode = $self->{'tree_ctrl'}->AppendItem ($node,
				"$param->{str}: " . $instconfig->getUIStringFromValue ($param_id, $instconfig->getLogValue ($param_id)));
			$self->{tree_ctrl}->SetItemFont ($subnode, SDBFONT_BoldText) if (!$is_gtk1);
			foreach my $param_id (@{$instconfig->getParamIds ()}){
				next if (grep {$_ eq $param_id} (@user_param_ids, 'Domain', 'SID'));
				
				$param = $instconfig->{params}->{$param_id};
			
				if ($param->{skip} || (defined $param->{hidden} && $param->{hidden})){
					next;
				}
				if ($param_id eq 'BasePathDataVolumes' ||
					$param_id eq 'BasePathLogVolumes'){
					my $val = $instconfig->getValue ($param_id);
					if (!defined $val){
						$val = $instconfig->getDefault ($param_id);
					}
					if (defined $subnode){
						$self->{'tree_ctrl'}->AppendItem ($subnode,
						"$param->{str}: " . $val);
					}
					else{
						$subnode = $self->{'tree_ctrl'}->AppendItem ($node,
						"$param->{str}: " . $val);
						$self->{tree_ctrl}->SetItemFont ($subnode, SDBFONT_BoldText) if (!$is_gtk1);
					}
					next;
				}
				
				my $str = $instconfig->getSummaryItem($param_id, 1);
				if (defined $str) {
					$self->{'tree_ctrl'}->AppendItem ($subnode, $str);
				}
			}
			$self->{tree_ctrl}->Expand ($subnode);
			$subnode = $self->{'tree_ctrl'}->AppendItem ($node,
					sprintf ('System Administrator (%s)', $sys->getUser()->getSidAdmName()));
					
			$self->{tree_ctrl}->SetItemFont ($subnode, SDBFONT_BoldText) if (!$is_gtk1);
		
			foreach my $param_id (@user_param_ids){
				my $str = $instconfig->getSummaryItem($param_id);
				if (defined $str) {
					$self->{'tree_ctrl'}->AppendItem ($subnode, $str);
				}
			}
			$self->{tree_ctrl}->Expand ($subnode);
		}
	}
	else{
		# upgrade
		$self->{'tree_ctrl'}->AppendItem ($node,
					'System Id: ' . $sys->get_sid);
					
		my $instances = $sys->getNewDBInstances ();
		my $instance;
		if (defined $instances && defined $instances->[0]){
			$instance = $instances->[0];
		}
		
		$self->{'tree_ctrl'}->AppendItem ($node,
			'Instance Number: ' . (defined $instance ?
				$instance->{_nr} : '<unknown>'));
				
		$self->{'tree_ctrl'}->AppendItem ($node,
					'Version: ' . $sys->GetVersion);

		#$self->{'tree_ctrl'}->AppendItem ($node,
		#			'IntegratedSystem: ' . ($sys->get_integratedSystem ? 'YES' : 'NO'));
	
		#$self->{'tree_ctrl'}->AppendItem ($node,
		#			'GlobalSidDir: ' . $sys->get_globalSidDir);
		
		#$self->{'tree_ctrl'}->AppendItem ($node,
		#			'SystemCocktail: ' . new SystemCocktail ($sys->{_systemCocktail})->getStringType());

		if ($sys->get_integratedSystem()){
			$self->{'tree_ctrl'}->AppendItem ($node,
					'Instance Types: ' . join (', ', @{$sys->getTypeList()}));
		}

		foreach my $instance (values %{$sys->{_instances}}){
			if ($instance->isNewDB()){
				$self->{'tree_ctrl'}->AppendItem ($node,
					'Instance Directory: ' . $instance->{_instanceDir});
				$self->{'tree_ctrl'}->AppendItem ($node,
					'Host(s): ' . join (', ', @{$instance->get_allhosts ()}));
			}
		}
	}
	
	#
	#   add components to tree
	#
	{
		my $componentsNode = SDB::Install::DatabaseStudioSummary::buildSoftwareComponentsNode($kit);
        $self->_addTreeNode($componentsNode, $node);		
	}

		
	#
	#   Add Database stuff
	#

    #TODO: later

    #
    #   Expand the root an the first layer
    #

#root
    $self->{'tree_ctrl'}->Expand($self->{'tree_ctrl'}->GetRootItem());
    #first layer
    #my ($item, $cookie) = $self->{'tree_ctrl'}->GetFirstChild( $self->{'tree_ctrl'}->GetRootItem() );
    #while( $item->IsOk() )
    #{
     #   $self->{'tree_ctrl'}->Expand($item);
     #   ($item,$cookie) = $self->{'tree_ctrl'}->GetNextChild( $self->{'tree_ctrl'}->GetRootItem(), $cookie );
    #}
    
    $self->Layout();
	return {}; #{'auto_next' => 1};
}	

sub _addTreeNode {
    my ($self, $summaryNodeRef, $parentTreeNode) = @_;
    
    my $treeControl = $self->{'tree_ctrl'};
    my $currentTreeNode;
    my $currentNodeText = $summaryNodeRef->{"text"};
    if (!defined $parentTreeNode) {
        $currentTreeNode = $treeControl->AddRoot($currentNodeText);     
    } else {
        $currentTreeNode = $treeControl->AppendItem($parentTreeNode, $currentNodeText);
    }
    
    my $childrenRef = $summaryNodeRef->{"children"};
    if (!defined $childrenRef) {
        return;
    }
    $treeControl->SetItemFont ($currentTreeNode, SDBFONT_BoldText) if (!$is_gtk1);
    $treeControl->SetItemText ($currentTreeNode, $currentNodeText) if (!$is_gtk1);
    foreach my $childRef (@{ $childrenRef }) {
        $self->_addTreeNode($childRef, $currentTreeNode);
    }
}

sub Process{
	my ($self,$config) = @_;

	return {};
}

sub Back{
    $_[0]->{'tree_ctrl'}->DeleteAllItems();
    $_[0]->GetWizard->SetInstallMode (0);
	$_[0]->GetWizard ()->EnableNextButton ();
	return 1;
}


sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
    
    #
    #   Destroy other elements
    #
    foreach my $element (  'tree_ctrl',
                        'titel_big',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
