#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Configuration dialog => System Properties 

package SDB::Install::Gui::Dialogs::SystemProperties;

use SDB::Install::Gui::Dialogs::GenericParameter;
use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Configuration qw ($bool_false_pattern $bool_true_pattern);

use Wx qw(wxALIGN_CENTER_VERTICAL wxEXPAND wxALIGN_TOP wxSL_LABELS wxSL_HORIZONTAL);
use Wx::Event qw( EVT_CHECKBOX EVT_TEXT EVT_COMBOBOX);

use strict;

our @ISA = qw (SDB::Install::Gui::Dialogs::GenericParameter);


sub new{
    my($self ) = shift->SUPER::new(@_);
    $self->{id} = 'SWProperties';
    $self->{label_text} = "Specify the System Properties";
    $self->{name} = 'Define System Properties';
    return $self;
}


sub getParamKeys{
    my ($self, $instconfig) = @_;
    return [($isWin ? () : 'Target'),'SID', 'InstanceNumber',($isWin ? 'Drive' : ()), , 'WorkerGroup', 'DbMode', ($isWin ? () : 'DbIsolation'), 'SystemUsage'];
}

sub resetSkippedParams {
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	if (defined $instconfig->{params}->{DbIsolation}) {
		$instconfig->{params}->{DbIsolation}->{skip} = 0;
	}
	return 1;
}

sub addControls {
	my ($self, $sizer) = @_;
	if (exists $self->{dynctrl}->{'Drive_ctrl'}){
		EVT_TEXT($self, $self->getParamCtrl('Drive')->GetId(),\&onDriveControl);
	}

	if (exists $self->{dynctrl}->{'SID_ctrl'}){
		EVT_TEXT($self, $self->getParamCtrl('SID')->GetId(), \&onSIDControl);
	}
	my $instconfig = Wx::wxTheApp()->{instconfig};
	if ((exists $self->{dynctrl}->{'DbMode_ctrl'}) && (exists $self->{dynctrl}->{'DbIsolation_ctrl'})){
		EVT_COMBOBOX($self, $self->getParamCtrl('DbMode')->GetId(), \&onDbModeControl);
		my $initialDbMode = $instconfig->{params}->{DbMode}->{value};
		if (!defined $initialDbMode) {
			$initialDbMode = $instconfig->getDefault('DbMode');
		}
		if ($initialDbMode =~ /^single/) {
			$self->getParamCtrl('DbIsolation')->Enable(0);
		}
	}

	if ($self->_shouldAddRestrictMaxMemoryControls()) {
		$self->_addRestrictMaxMemory();
		$self->_addMaxMemory();
	}

	if (!(exists $self->{dynctrl}->{'AutoStart_ctrl'})) {
		$self->_addAutoStart();
	}

	if (defined $instconfig->{params}->{'EnableXSEngine'}){
		$self->_addEnableXSEngine();
	}
	my $sid = $instconfig->getValue ('SID');
	if (!defined $sid){
		$sid = $instconfig->getDefault ('SID');
	}
	if (defined $sid){
		$self->getParamCtrl('SID')->SetValue ('');   # reset -> trigger event
		$self->getParamCtrl('SID')->SetValue ($sid); # set SID
	}
	return 1;
}

sub _shouldAddRestrictMaxMemoryControls {
	my ($self,) = @_;
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $controlsAreNotCreated = ( ! exists $self->{dynctrl}->{'RestrictMaxMem_ctrl'} || ! exists $self->{dynctrl}->{'MaxMem_ctrl'} ) ? 1 : 0;
	my $parametersAreNotSkipped = ( ! $instconfig->isSkipped('RestrictMaxMem') && ! $instconfig->isSkipped('MaxMem')) ? 1 : 0;
	return $controlsAreNotCreated && $parametersAreNotSkipped; 
}

sub _addRestrictMaxMemory {
	my ($self,) = @_;
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $rMemParam = $instconfig->{params}->{'RestrictMaxMem'};
	my $restrictMaxMemCheckBox = new Wx::CheckBox ($self, -1,$rMemParam->{'str'}, [-1,-1], [-1,-1]);
	$restrictMaxMemCheckBox->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	EVT_CHECKBOX($self, $restrictMaxMemCheckBox->GetId(), \&onRestrictMaxMem);
	my %options = (
		'parameterId' => 'RestrictMaxMem',
		'controlType' => 'ctrl',
		'controlOptions' => [0, wxEXPAND | wxALIGN_TOP]
	); 
	my $value = (defined $rMemParam->{value} ? $rMemParam->{value} : $instconfig->getDefault('RestrictMaxMem'));
	$restrictMaxMemCheckBox->SetValue($value);
	if (defined $rMemParam->{set_interactive} && !$rMemParam->{set_interactive} && !$rMemParam->{skip}){
		$restrictMaxMemCheckBox->Show(0);
	}

	if (defined $rMemParam->{value} && !$rMemParam->{skip}) {
		$restrictMaxMemCheckBox->Enable(0);
	}
	$self->addControlToGridSizer($restrictMaxMemCheckBox, \%options );
	$options{parameterId} = 'RestrictMaxMemSpace';
	$options{controlType} = 'label';
	$self->addControlToGridSizer( new Wx::StaticText ($self, -1, ''), \%options );
}

sub _addMaxMemory {
	my ($self,) = @_;
	my $labelText = 'Memory in MB';
	my $maxMemLabel = new Wx::StaticText ($self, -1, $labelText);
	$maxMemLabel->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	my %options = (
		'parameterId' => 'MaxMem',
		'controlType' => 'label',
		'controlOptions' => [0, wxALIGN_CENTER_VERTICAL]
	); 
	$self->addControlToGridSizer($maxMemLabel, \%options );

	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $memParam = $instconfig->{params}->{'MaxMem'};	
	my $value = (defined $memParam->{value} ? $memParam->{value} :	$instconfig->getDefault('MaxMem'));
	my $maxMemControl = new Wx::Slider ($self, -1, $value, $memParam->{minValue} ,$memParam->{maxValue}, [-1,-1], [-1,-1], wxSL_HORIZONTAL | wxSL_LABELS);
	$maxMemControl->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	%options = (
		'parameterId' => 'MaxMem',
		'controlType' => 'ctrl',
		'controlOptions' => [1, wxEXPAND | wxALIGN_TOP]
	); 
	$self->addControlToGridSizer($maxMemControl, \%options );

	if (defined $memParam->{set_interactive} && !$memParam->{set_interactive} && !$memParam->{skip}){
		$maxMemControl->Show(0);
	}

	if ((defined $memParam->{value} && !$memParam->{skip}) || $self->{dynctrl}->{'RestrictMaxMem_ctrl'}->IsEnabled()) {
		$maxMemControl->Enable(0);
	}
}

sub _addAutoStart {
	my ($self,) = @_;
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $param = $instconfig->{params}->{'AutoStart'};
	my $autoStartControl = new Wx::CheckBox ($self, -1,$param->{'str'}, [-1,-1], [-1,-1]);
	$autoStartControl->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	my %options = (
			'parameterId' => 'AutoStart',
			'controlType' => 'ctrl',
			'controlOptions' => [0, wxEXPAND | wxALIGN_TOP]
		); 
	my $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault('AutoStart'));
	$autoStartControl->SetValue($value);
	if (defined $param->{set_interactive} && !$param->{set_interactive}){
		$autoStartControl->Show(0);
	}
	if (defined $param->{value}) {
		$autoStartControl->Enable(0);
	}
	$self->addControlToGridSizer($autoStartControl, \%options );

	$options{parameterId} = 'AutoStartSpace';
	$options{controlType} = 'label';
	$self->addControlToGridSizer( new Wx::StaticText ($self, -1, ''), \%options );
}

sub _addEnableXSEngine {
	my ($self,) = @_;
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $param = $instconfig->{params}->{'EnableXSEngine'};
	my $enableXSEngineControl = new Wx::CheckBox ($self, -1,$param->{'str'}, [-1,-1], [-1,-1]);
	$enableXSEngineControl->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	my %options = (
			'parameterId' => 'EnableXSEngine',
			'controlType' => 'ctrl',
			'controlOptions' => [0, wxEXPAND | wxALIGN_TOP]
	); 
	my $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault('EnableXSEngine'));
	$enableXSEngineControl->SetValue($value);
	if (defined $param->{set_interactive} && !$param->{set_interactive}){
		$enableXSEngineControl->Show(0);
	}
	if (defined $param->{value}) {
		$enableXSEngineControl->Enable(0);
	}
	$self->addControlToGridSizer($enableXSEngineControl, \%options );
}

sub onDriveControl {
	my ($self,$evt) = @_;
	return if (!exists $self->{dynctrl}->{Target_ctrl});
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $default = $instconfig->getDefault ('Target');
	if ($default eq $self->{dynctrl}->{Target_ctrl}->GetValue){
		my $text = $instconfig->getDefault ('Target',$evt->GetString());
		$instconfig->setDefault('Drive', $evt->GetString());
		$self->{dynctrl}->{Target_ctrl}->SetValue ($text);
	}
}

sub onSIDControl {
	my ($self,$evt) = @_;
	my $str = $evt->GetString();
	my $instconfig = Wx::wxTheApp()->{instconfig};
	my $kit = Wx::wxTheApp()->{kit};
	if (length ($str) == 3){
		$instconfig->{params}->{SID}->{value} = $str;
		$instconfig->{current_sid} = $str;
		if ($instconfig->pers_exists){
			$instconfig->Reset();
			$instconfig->InitDefaults ($kit);
			$instconfig->validatePersistency ();
			$self->{loaded} = 1;
			$self->SyncCtrls ($instconfig);
			return;
		}
	}
	if ($self->{loaded}){
		$instconfig->Reset();
		$instconfig->InitDefaults ($kit);
		$self->SyncCtrls ($instconfig);
		$self->{loaded} = 0;
	}
}

sub onDbModeControl {
	my ($self,$evt) = @_;
	my $str = $evt->GetString();
	my $enable = $str =~ /^multi/ ? 1 : 0; 
	$self->{dynctrl}->{'DbIsolation_ctrl'}->Enable( $enable );
}

sub onRestrictMaxMem {
	my ($self,$evt) = @_;
	$self->{dynctrl}->{'MaxMem_ctrl'}->Enable($evt->IsChecked());
}

sub Process{
    my ($self,$config) = @_;

    my $rc = $self->SUPER::Process ($config);

	my $instconfig = Wx::wxTheApp->{instconfig};
    my $param;
    my $ctrl;
    foreach my $param_id ('AutoStart', 'RestrictMaxMem', 'EnableXSEngine'){
        $param = $instconfig->{params}->{$param_id};
        if (!defined $param) {
            next;
        }
        if (defined $param->{set_interactive} && !$param->{set_interactive}){
            next;
        }
        if (not defined $param->{value}) {
            $ctrl = $self->getParamCtrl ($param_id);
            if (!defined $ctrl) {
                next; # skip if there is no control added for this parameter
            }
            $param->{value} = $ctrl->GetValue() ? 1 : 0;
        }
    }
    my $restrictMaxMem = $instconfig->{params}->{RestrictMaxMem}->{value};
    if (defined $restrictMaxMem && ($restrictMaxMem =~ /$bool_true_pattern/i)){
        $instconfig->{params}->{MaxMem}->{value} = $self->{dynctrl}->{'MaxMem_ctrl'}->GetValue();
    } else {
        $instconfig->{params}->{MaxMem}->{value} = 0;
    }

    #
    # skipping sidadm properties if it's already exist
    #

    $self->GetWizard ()->SkipDialog ('UserProperties',
        $instconfig->{params}->{Password}->{skip} ? 1 : 0);

    return $rc;
}


sub SyncCtrls{
    my ($self, $instconfig) = @_;
    my $hasValidValues;
    my $ctrl;
    foreach my $param_id (@{$instconfig->getParamIds ()}){

        if ($param_id eq 'SID'){
            next;
        }

        $hasValidValues = defined $instconfig->{params}->{$param_id}->{valid_values};
        $ctrl = $self->getParamCtrl($param_id);
        if (defined $ctrl){
            if (defined $instconfig->{params}->{$param_id}->{value}){
                $ctrl->SetValue ($hasValidValues ? $instconfig->getUIStringFromValue($param_id, $instconfig->{params}->{$param_id}->{value}) : $instconfig->{params}->{$param_id}->{value});
                $ctrl->Enable (0);
            }
            else{
                $ctrl->SetValue ($hasValidValues ? $instconfig->getUIStringFromValue($param_id, $instconfig->getDefault ($param_id)) : $instconfig->getDefault ($param_id));
                $ctrl->Enable (1);
            }
        }
    }

	my $param = $instconfig->{params}->{'AutoStart'};
   	my $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault('AutoStart'));
	$ctrl = $self->getParamCtrl ('AutoStart');
	$ctrl->SetValue($value);
	if (defined $param->{value}) {
		$ctrl->Enable(0);
	} else {
		$ctrl->Enable(1);
	}
	$ctrl = $self->getParamCtrl ('EnableXSEngine');
    if(defined $ctrl) {
        $param = $instconfig->{params}->{'EnableXSEngine'};
        $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault('EnableXSEngine'));
        $ctrl->SetValue($value);
        if (defined $param->{value}) {
            $ctrl->Enable(0);
        } else {
            $ctrl->Enable(1);
        }
    }
}

sub Cleanup{
	my ($self) = @_;
	if (defined $self->{dynctrl}->{'AutoStart_ctrl'}){
		delete $self->{dynctrl}->{'AutoStart_ctrl'};
	}
	
	if (defined $self->{dynctrl}->{'EnableXSEngine_ctrl'}){
		delete $self->{dynctrl}->{'EnableXSEngine_ctrl'};
	}
 	$self->SUPER::Cleanup();
}

1;
