#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SDB::Install::Gui::Dialogs::UninstallFinalized;

use Wx qw ( 
    wxNORMAL
    wxBOLD
    wxTE_MULTILINE
    wxTE_READONLY
    wxEXPAND
    wxVERTICAL
    wxTOP
    wxHORIZONTAL
    wxID_EXIT
    wxALL
    wxBOTTOM
    wxLI_VERTICAL
    wxALIGN_CENTER
    wxOK
    wxCENTRE
    wxICON_EXCLAMATION
          );

use SDB::Install::Gui::Design;
use SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Globals qw ($gProductNameInstaller);

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

sub new{
	my($self ) = shift->SUPER::new(@_);

	$self->{id} = 'uninstall_finalize';

	$self->{name} = 'Finish';


    #
    #   Sizer Stuff
    #

    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $top_sizer->AddStretchSpacer(1);    

    #
    #   Caption
    #

    $self->{'caption'} = Wx::StaticText->new($self,-1,"");
    $self->{'caption'}->SetFont( Wx::Font->new(14,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1());
    $top_sizer->Add($self->{'caption'},0,wxALIGN_CENTER);

    #
    #   Text
    #

    $self->{'text'} = Wx::StaticText->new($self,-1,"");
    $self->{'text'}->SetFont ( Wx::Font->new(10,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1()); 
    $top_sizer->Add($self->{'text'},0,wxALIGN_CENTER | wxTOP,20);

    #
    #   Pack&Go
    #

    $top_sizer->AddStretchSpacer(1);
    $self->SetSizer($top_sizer);
	$self->SetAutoLayout(1);
	$self->Layout();
    
	return $self;
}


sub SetBusy{
    my ($self,$busy) = @_;
    if(not defined $busy or $busy){
        $self->Enable(0);
    }
    else{
        $self->Enable(1);       
    }
    return 1;
}


sub init(){
	my ($self,$config) = @_;
    
    $self->SetBusy(1);
    
    $self->{'initialized'} = 1;
    my $app = Wx::wxTheApp;
    if($config->{'error_state'} == 1){
        $self->{'caption'}->Show(1);
		$self->{'caption'}->SetLabel('An error occurred.');
        $self->{'text'}->SetLabel('For detailed information, please see the log file.');
    }
    else{
		$self->{'caption'}->Show(0);
		$self->{'text'}->SetLabel('You have successfully uninstalled ' . $app->{installation}->getProductName. '.');
    }
    return {'auto_next' => 1};
}


sub Process{
	my ($self,$config) = @_;

    $self->GetWizard->LayoutDlg();
    $self->GetWizard()->KillPreviousDialogs();
    
    #
    #   Add Log Viewer
    #

    my $app = Wx::wxTheApp;
    $app->CleanUp ();
    $self->GetWizard->LogButton('&View Log',sub {
            my ($self,$evt) = @_;
            eval{
                require SDB::Install::LogViewer::Dialog::XLVDialog;
            };
            if ($@){
                Wx::MessageBox( "Error: $@", 'Log Viewer Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
                return undef; # Stay in current dialog!
            } else {
                my ($frame) = SDB::Install::LogViewer::Dialog::XLVDialog->new( undef, "$gProductNameInstaller - XML Log Viewer", Wx::Point->new(300,100), Wx::Size->new(640,800) );
                $frame->LoadMsgLstAfterShow ($app->getMsgLst());
                $frame->SetSize(640,800);
                $frame->SetMinSize([450,600]);
                $frame->ShowModal();
                $frame->Destroy();
                $frame = undef;
            }
      } );
        
    $self->GetWizard->{'cbutton'}->SetFocus;
    
	return {};
}


sub BackInit{
	my ($self,$config) = @_;
    
	return {};
}


sub Back{
    my ($self,$config) = @_;
    
    return 1;
}


sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
    foreach my $element (  
                        'caption',
                        'text',
                        'staticline',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
