#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: User options for software configuration dialog

package SDB::Install::Gui::Dialogs::UpgradeParameter;

use SDB::Install::Gui::Dialogs::GenericParameter;
use SDB::Install::SAPSystem qw (CollectSAPSystems);
use strict;

our @ISA = qw (SDB::Install::Gui::Dialogs::GenericParameter);

sub new{
	my($self ) = shift->SUPER::new(@_);
	$self->{id} = 'UpgradeProperties';
	$self->{name} = 'Define Upgrade Properties';
	$self->{label_text} = "Specify authorization data";
	return $self;
}

sub getAlreadySetParamKeys{
	return ['SID'];
}

sub Process{
    my ($self, @args) = @_;
    my $rc = $self->SUPER::Process (@args);
    if (defined $rc && !defined $rc->{error_state}){
        my $app = Wx::wxTheApp();
        my $instconfig = $app->{instconfig};
        my $systems = CollectSAPSystems ();
        my $sys = $systems->{$instconfig->getValue ('SID')};
        $sys->setCallback (\&Wx::Yield);
        $sys->resetError();
        if ($self->shouldCheckUpdate() and !defined $sys->checkUpdate ($instconfig)){
            my $errlst = new SDB::Install::MsgLst ();
            $errlst->addError ('Checking upgrade failed', $sys->getErrMsgLst ());
             $app->ShowErrorMsg ('Error', $errlst);
            return undef;
        }
    }
    return $rc;
}

sub shouldCheckUpdate{
	return 1;
}

1;
