#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: User options for software configuration dialog

package SDB::Install::Gui::Dialogs::User;

use Wx qw (
    wxCENTRE
    wxVERTICAL
    wxDefaultSize 
    wxSWISS
    wxNORMAL
    wxBOLD
    wxHORIZONTAL
    wxEXPAND
    wxALL
    wxLEFT
    wxALIGN_CENTER_VERTICAL
    wxALIGN_CENTER_HORIZONTAL 
    wxALIGN_RIGHT
    wxTE_MULTILINE
    wxOK
    wxTOP
    wxBOTTOM
    wxCENTRE
    wxICON_EXCLAMATION
    wxID_OK
    wxDD_NEW_DIR_BUTTON
    wxBITMAP_TYPE_PNG
    wxALIGN_LEFT
    wxTE_PASSWORD
    wxSP_ARROW_KEYS
    wxCB_READONLY
    wxTE_READONLY
    );

use Wx::Event qw( EVT_BUTTON EVT_CHECKBOX EVT_TEXT  );
                    
use SAPDB::Install::Wizard::Dialog::Base;
use SAPDB::Install::Control::PathCtrl;
use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gProductName);
use SDB::Install::Gui::Control::Label;
use SAPDB::Install::Window::DBUserSimple;
use SDB::Install::SysVars qw ($isWin);
use strict;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);


our @user_params = $isWin ? ('Domain') : ('UID','GID','Shell', 'HomeDir');

sub new {
	my($self ) = shift->SUPER::new(@_);

    $self->{id} = 'UserProperties';
    $self->{label_text} = 'Specify the Properties of the System Administrator';
    $self->{name} = 'Define System Administrator';

    return $self;
}


sub init {
	my ($self,$config) = @_;

	my $is_gtk1 =  Wx::wxGTK1();

	#
	#   Get default values
	#

	my $app = Wx::wxTheApp;

	my ($instconfig, $kit) = (
		$app->{instconfig},  # systeminstallation
		$app->{kit},    #packages
		);
	#
	# set parameters by cfg file and cmdln args 
	#
	
	my $msg = $app->getMsgLst->addMessage ("Checking configuration of installation (dialog $self->{name})");
	$msg->setEndTag ('Configuration Check');
    $instconfig->setMsgLstContext([$msg->getSubMsgLst(),undef]);
	my $paramKeys = \@user_params;
	# init batch values of required parameters
	for my $paramKey ( @$paramKeys ) {
		next if ( ! defined $paramKey);

		if ( ! defined $instconfig->setBatchValueOfRequiredParams ($paramKey) ) {
			$app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
			return undef;
		}
	}
	
	if ($instconfig->{params}->{Password}->{skip}){
		# user already exists
		return {'auto_next' => 1};
	}
	
	if($self->{batch_mode}){
		if ($instconfig->errorState()){
			$app->setErrorMessage ("running in batch mode", $instconfig->getErrMsgLst ());
			$app->PrintUsage ();
			return undef;
		}
	}

	#
	#   Create Dialog
	#

	my $sizer = Wx::BoxSizer->new(wxVERTICAL);
	#my $left_sizer = Wx::BoxSizer->new(wxVERTICAL);
	
	#Titel
	$sizer->AddSpacer (16);
	$self->{'titel_big'} = Wx::StaticText->new($self, -1, $self->{label_text});
	$self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);
	$sizer->Add($self->{'titel_big'},0, wxLEFT , 16 );
	$sizer->AddSpacer (16);
	$self->{'grid_sizer'} = Wx::FlexGridSizer->new(6, 2, 5, 15);
	
	$self->{isConfirmPasswordNeeded} = 0;
    if($instconfig->getType('Password') eq 'initial_passwd'){
        $self->{isConfirmPasswordNeeded} = 1;
    }

	if(!$instconfig->isHidden('Password') || !$self->{isConfirmPasswordNeeded}){
		$self->{user_window} = new SAPDB::Install::Window::DBUserSimple ($self,-1);
		my $password = $instconfig->getValue ('Password');
		$self->{user_window}->SetValue ({'Name' => $instconfig->{username}, (defined $password ? ('Password' , $password, 'ConfirmPassword', $password) : ())});
		$self->{user_window}->{ctrl_user}->Enable (0);
		$self->{user_window}->{label_confirm_passwd}->Show(0) if (!$self->{isConfirmPasswordNeeded});
		$self->{user_window}->{ctrl_confirm_passwd}->Show(0) if (!$self->{isConfirmPasswordNeeded});
		$sizer->Add($self->{user_window},0, wxLEFT , 16 );
		$sizer->AddSpacer (16);
	}

	$sizer->Add ($self->{'grid_sizer'},1, wxEXPAND | wxALL, 16);

	my %dynctrl;
	
	my ($param,$value);

	my @shells = qw (/bin/bash /bin/csh /bin/sh);
	
	my $context;

	if (defined $self->{context} && defined $self->{context}->{$instconfig->{username}}){
		$context = $self->{context}->{$instconfig->{username}};
	}
	
	foreach my $param_id (@user_params){
		$param = $instconfig->{params}->{$param_id};
		if (defined $param->{set_interactive} && !$param->{set_interactive}){
			next;
		}

		$dynctrl{$param_id . '_label'} = 
			SDB::Install::Gui::Control::Label->new
				( $self, -1, $param->{'str'},
					$param->{mandatory});
		
		
		$value = (defined $param->{value} ? $param->{value} :
			$instconfig->getDefault ($param_id));

		$dynctrl{$param_id . '_ctrl'} = 
			$param_id eq 'Shell' ?
				new Wx::ComboBox ( $self, -1,$value, [-1,-1],[-1,-1],\@shells, wxCB_READONLY) :
            $param->{type} eq 'number' ?
                    new  Wx::TextCtrl ( $self, -1, $value,[-1,-1], [-1,-1]) :
			$param->{type} eq 'passwd' ?
				new Wx::TextCtrl ( $self, -1, $value,[-1,-1], [-1,-1],wxTE_PASSWORD ) :
			$param->{type} eq 'path' ?
				new SAPDB::Install::Control::PathCtrl ($self,-1,$value, [-1,-1], [-1,-1]) :
				new Wx::TextCtrl ( $self, -1, $value,[-1,-1], [-1,-1]);

		if (defined $context && exists $context->{$param_id}){
			$dynctrl{$param_id . '_ctrl'}->SetValue ($context->{$param_id});
		}
		#elsif (defined $param->{value}){
			#$dynctrl{$param_id . '_ctrl'}->Enable (0);
		#}
		
		if (defined $param->{desc}){
			$dynctrl{$param_id . '_label'}->SetToolTip ($param->{desc});
			$dynctrl{$param_id . '_ctrl'}->SetToolTip ($param->{desc});
		}

		$self->_disableCtrl($param_id, $dynctrl{$param_id . '_ctrl'});
	
		$self->{'grid_sizer'}->Add($dynctrl{$param_id . '_label'},0, wxALIGN_CENTER_VERTICAL);
		$self->{'grid_sizer'}->Add($dynctrl{$param_id . '_ctrl'}, 1, wxEXPAND);
	}

    $self->AddAdditionalParams($instconfig);

	$self->{dynctrl} = \%dynctrl;

	$self->{'grid_sizer'}->AddGrowableCol( 1 );
	$self->{grid_sizer}->Layout ();
	
	
	my ($x1,$y1) = $dynctrl{$user_params[0] . '_label'}->GetPositionXY();
	my ($x2,$y2) = $dynctrl{$user_params[0] . '_ctrl'}->GetPositionXY();
	
	my $w = $x2 - $x1;

	if(defined($self->{user_window})){
		$self->{user_window}->setColSize ($w);
	}

	$self->SetSizerAndFit($sizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	
	$self->Show(1);
	
	if ($instconfig->ErrorState){
		$self->GetWizard ()->LayoutDlg ();
		Wx::MessageBox($instconfig->GetErrorString (), "Configuration Error",
			 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
	}
	return {}; 
}

sub AddAdditionalParams {
    my ($self,$instconfig) = @_;	
    return 1;	
}

sub Process{
	my $self = shift();
	my $instconfig = Wx::wxTheApp->{instconfig};

	if ($instconfig->{params}->{Password}->{skip}){
		# user already exists
		return {'auto_next' => 1};
	}
	$instconfig->resetError ();

	my ($param, $value, $ctrl);
	my $dynctrl = $self->{dynctrl};
	my $msglst = $instconfig->getMsgLst ();
	my ($old_value, $logvalue);

	if (!defined $self->{context}){
		$self->{context} = {$instconfig->{username} => {}};
	}
	elsif(!defined $self->{context}->{$instconfig->{username}}){
		$self->{context}->{$instconfig->{username}} = {};
	}
	
	my $context = $self->{context}->{$instconfig->{username}};

	foreach my $param_id (@user_params){
		$param = $instconfig->{params}->{$param_id};
		
		if ($param->{skip}){
			next;
		}
	
		if (defined $param->{set_interactive} && !$param->{set_interactive}){
			next;
		}
		
		$ctrl = $dynctrl->{$param_id . '_ctrl'};
		
		if (defined $ctrl){
			$value = $ctrl->GetValue ();

			if ($value !~ /\S/){
				#$value = undef;
			}
			$old_value = $param->{value};
			if (!$instconfig->setValue ($param_id, $value)){
				Wx::MessageBox( "$param->{str} is invalid.\n" .
					 $instconfig->GetErrorString (), "Configuration Error",
					 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
				$ctrl->SetFocus();
				return undef;
			}
			$context->{$param_id} = $value;
			$logvalue = $instconfig->getLogValue ($param_id, $value);
			if (!defined $old_value || $old_value ne $param->{value}){
				if ($param->{type} eq 'number' &&
					int ($instconfig->getDefault ($param_id)) == int ($value) || 
					$instconfig->getDefault ($param_id) eq $value){
					$msglst->addMessage ( $self->_getUserConfirmationMessagePattern( $param, $param_id, $logvalue) );
				}
				else{
					$msglst->addMessage ( $self->_getIsSetByUserMessagePattern($param, $param_id, $logvalue) );
				}
			}
			elsif (!defined $param->{value}){
				$msglst->addMessage ( $self->_getSetByUserMessagePatterni($param) );
			}
			
		}
	}

	if(!$self->_setValuePassword($instconfig)){
		return undef;
	}

	return {};
}

sub Back{
	my ($self) = @_;
	
	my $msglst = new SDB::Install::MsgLst ();
	my $instconfig = Wx::wxTheApp->{instconfig};
	my $context;
	$msglst->addMessage ('Reverting user changes (wizard backward navigation)');
	if (defined $self->{context} && defined $self->{context}->{$instconfig->{username}}){
		$context = $self->{context}->{$instconfig->{username}};
	}
	if (defined $context){
		foreach my $param_id (keys (%$context)){
			$instconfig->{params}->{$param_id}->{value} = undef;
		}
	}
	$self->Reset();
}

sub Reset{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
	delete $self->{title_big};
	delete $self->{dynctrl};
	delete $self->{user_window};
	$self->SUPER::Reset();
}

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub _setValuePassword {
	my ($self, $instconfig) = @_;
	return 1 if(defined $instconfig->getValue('Password'));
	my $user_values = $self->{user_window}->GetValue ();

	if (!$user_values->{Password}){
		Wx::wxTheApp ()->ShowErrorMsg ("System Administrator Password is empty");
		$self->{user_window}->{ctrl_passwd}->SetFocus();
		return undef;
	}
	if ($self->{isConfirmPasswordNeeded}){
	    if ($user_values->{Password} ne $user_values->{ConfirmPassword}){
		    Wx::wxTheApp ()->ShowErrorMsg ("Password confirmation doesn't match");
		    $self->{user_window}->SetFocus();
		    return undef;
	    }
    }
	if (!$instconfig->setValue('Password', $user_values->{Password})){
		Wx::wxTheApp ()->ShowErrorMsg ("Invalid Password",$instconfig->getErrMsgLst ());
		$self->{user_window}->SetFocus();
		return undef;
	}
	return 1;
}

sub _disableCtrl {
    my ($self, $param_id, $ctrl) = @_;
    my $instconfig = Wx::wxTheApp->getInstconfig();

    if ($instconfig->getType($param_id) eq 'number' && $instconfig->getValue($param_id)){
        $ctrl->Enable(0);
    }
    if ($param_id eq 'HomeDir' && $instconfig->getValue('UID')) {
        $ctrl->{'edit'}->Enable(0);
        $ctrl->{'button'}->Enable(0);
    }
}

1;
