#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Dialog Design

package SDB::Install::Gui::Event;

our @ISA = qw (Exporter);

use Wx;
use Wx::Event qw (EVT_COMMAND);

our @EXPORT = qw (EVT_SDB_FIND_NEXT
				  EVT_SDB_FIND_PREVIOUS
				  EVT_SDB_FIND_HIGHLIGHT
				  EVT_SDB_FIND_MATCH_CASE
				  EVT_SDB_FIND_TEXT
				  EVT_SDB_VIEW_CHANGED
				  EVT_SDB_SELECT_STEP
				  EVT_SDB_SELECT_SUBSTEP
				  EVT_SDB_UNTERMINATE_CLICK
				  SDB_EVENT_TYPE_FIND_NEXT 
				  SDB_EVENT_TYPE_FIND_PREVIOUS
				  SDB_EVENT_TYPE_FIND_HIGHLIGHT
				  SDB_EVENT_TYPE_FIND_MATCH_CASE
				  SDB_EVENT_TYPE_FIND_TEXT
				  SDB_EVENT_TYPE_VIEW_CHANGED
				  SDB_EVENT_TYPE_SELECT_STEP
				  SDB_EVENT_TYPE_SELECT_SUBSTEP
				  SDB_EVENT_TYPE_UNTERMINATE_CLICK
				  );


sub SDB_EVENT_TYPE_FIND_NEXT () {
	return 8763;
}

sub SDB_EVENT_TYPE_FIND_PREVIOUS () {
	return 8764;
}

sub SDB_EVENT_TYPE_FIND_HIGHLIGHT () {
	return 8765;
}

sub SDB_EVENT_TYPE_FIND_TEXT () {
	return 8766;
}
sub SDB_EVENT_TYPE_FIND_MATCH_CASE () {
	return 8767;
}

sub SDB_EVENT_TYPE_VIEW_CHANGED () {
	return 8768;
}

sub SDB_EVENT_TYPE_SELECT_STEP () {
	return 8769;
}

sub SDB_EVENT_TYPE_SELECT_SUBSTEP () {
	return 8770;
}

sub SDB_EVENT_TYPE_UNTERMINATE_CLICK () {
	return 8771
}

sub EVT_SDB_FIND_NEXT ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_FIND_NEXT,$sub);
}

sub EVT_SDB_FIND_PREVIOUS ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_FIND_PREVIOUS,$sub);
}

sub EVT_SDB_FIND_HIGHLIGHT ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_FIND_HIGHLIGHT,$sub);
}

sub EVT_SDB_FIND_MATCH_CASE ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_FIND_MATCH_CASE,$sub);
}

sub EVT_SDB_FIND_TEXT ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_FIND_TEXT,$sub);
}

sub EVT_SDB_VIEW_CHANGED ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_VIEW_CHANGED,$sub);
}

sub EVT_SDB_SELECT_STEP ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_SELECT_STEP,$sub);
}

sub EVT_SDB_SELECT_SUBSTEP ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_SELECT_SUBSTEP,$sub);
}

sub EVT_SDB_UNTERMINATE_CLICK ($$$) {
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_UNTERMINATE_CLICK,$sub);
}

1;