#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 
#

package SDB::Install::Gui::Frame::StartUninstallation;

use Wx qw (
    wxDefaultSize
    wxOK
    wxBLACK
    wxGROW
    wxRED
    wxEVT_COMMAND_ENTER
    wxICON_ERROR
    wxHORIZONTAL
    wxCENTRE
    wxICON_INFORMATION
    wxVERTICAL
    wxLI_HORIZONTAL 
    wxEXPAND
    );

use Wx::Event qw (
    EVT_SIZE 
    EVT_COMMAND_ENTER 
    EVT_SET_FOCUS
    EVT_CLOSE);


#   Wizard structure
use SDB::Install::Gui::Window::Wizard;           
use SDB::Install::Gui::Window::SAPBanner;

#   Others
use SAPDB::Install::Frame::Base;
use SDB::Install::System;
use SAPDB::Install::Resources;

#   dialogs
use SDB::Install::Gui::Dialogs::UninstallSummary;
use SDB::Install::Gui::Dialogs::Uninstallation;
use SDB::Install::Gui::Dialogs::UninstallFinalized;

our @ISA = qw (SAPDB::Install::Frame::Base);

my $startWidth = 700; # Wizard start width

#   Ask for Admin permission and takes initial setup.
sub new {
 	my( $class ) = shift;
    my $motherdialog = shift;
    shift;
    my( $self ) = $class->SUPER::new(@_);
    $self->{'skipInstallationSelection'} = (!defined $motherdialog);
    
    #
    #   Is Admin?
    #

    my ($rc, $name) = isAdmin();

    if (defined $rc){				
        #unless(1 || $rc){ # <<<<<<<< Warnung: Admin is override 
        unless($rc){
            my $msgbox = Wx::MessageDialog->new($self,
                            $^O =~ /mswin/i ? 
                            'Please start installation as local administrator (your user has to be in group "'.$name.'")!' :
                            'Please restart as user root!',
                            "No Privileges", wxICON_ERROR | wxCENTRE | wxOK);
            $msgbox->ShowModal();
            $msgbox->Destroy();
            return;
        }

    }
    else{
        my $msgbox = Wx::MessageDialog->new($self,
                            'Cannot check account: '.$name,
                            "Warning: Testing Privileges", wxICON_ERROR | wxCENTRE | wxOK);
            $msgbox->ShowModal();
            $msgbox->Destroy();
            return;
    }
	
    #
    #   Events
    #
			
    EVT_CLOSE($self,\&OnClose);

	#
    #   Frame setup
    #
    
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);
    
    $sizer->SetMinSize([640, 480]);
    
    $self->{'start_width'} = $startWidth;
    
	$self->SetSizerAndFit($sizer);
	$self->SetAutoLayout(1);
	return $self;
}

#   Start the wizard. Build the UI Structure for the wizard and add steps to them.
#   Start the wizard. Build the UI Structure for the wizard and add steps to them.
sub StartWizard{
	my ($self) = @_;
	Wx::Yield();
    
    #
    #   Build new structure
    #
    
    $self->{'banner'} = SDB::Install::Gui::Window::SAPBanner->new($self,-1); # High is 83 because a little bit of the floorplan background belong to the banner
    $self->GetSizer->Add($self->{'banner'},0,wxEXPAND);

    
    #
    #   Grayline
    #

    #$self->{'grayline'} = Wx::StaticLine->new ($self, -1, [-1,-1], [-1,2], wxLI_HORIZONTAL, );
    #$self->GetSizer->Add($self->{'grayline'},0,wxEXPAND);

    #
    #   Wizard
    #

    my $wizard = SDB::Install::Gui::Window::Wizard->new($self,-1,[$self->{'start_width'},290],wxDefaultSize);
    $self->GetSizer->Add($wizard,1,wxEXPAND);

    my $app = Wx::wxTheApp ();
    $wizard->AddDialog (new SDB::Install::Gui::Dialogs::UninstallSummary ($wizard));
    $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Uninstallation ($wizard));
    $wizard->AddDialog (new SDB::Install::Gui::Dialogs::UninstallFinalized ($wizard));
    $wizard->terminateChain ();
    $wizard->init;
    $wizard->SetFocus ();
    $self->{'wizard'} = $wizard;
}


#>---------------------------------Sizer Stuff------------------------------------------<#

sub RecalcBestSize{
    my ($self) = @_;
    my $size = $self->GetBestSize;
    my ($width,$height) = ($size->GetWidth,$size->GetHeight);
    
    $self->SetSizeHints($width,$height); 
    my ($cur_width,$cur_height) = $self->GetSizeWH;
    my $dirty = 0;
    if($cur_width < $width){
        $cur_width = $width;
        $dirty = 1; 
    }
    if($cur_height < $height){
        $cur_height = $height;
        $dirty = 1; 
    }
    if($dirty){
        $self->SetSize([$cur_width,$cur_height]);
        $self->Layout;
    }
    $self->Layout;
    
}

#>---------------------------------Seek&Destroy Stuff------------------------------------------<#

sub OnClose{
    my ($self,$evt) = @_;
    $self->Destroy ();
}

sub Destroy{
	my ($self) = @_;
    if (defined $self->{wizard}){
        $self->{wizard}->Destroy;
        delete $self->{wizard};     
    }
    Wx::wxTheApp->CleanUp();
	$self->SUPER::Destroy;
}


sub DESTROY{
	my ($self) = @_;
	print ">>>>>> DESTROYING $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
