package SDB::Install::Gui::Window::Dialog::Usage;

use strict;

use Wx qw (wxOK);
use base 'SDB::Install::Gui::Window::Dialog::MessageDialog';
use SDB::Install::Gui::Design qw (SDBFONT_ProportionalText);


#-------------------------------------------------------------------------------
# Creates a window in  order to display the specified text.
#
# Parameters: string $text
#             string $windowTitle

sub new{
    my ($class,$parent,$id,$text,$windowTitle) = @_;
    my $self  = $class->SUPER::new(
        $parent,
        $text,
        $windowTitle,
        wxOK,
        undef,
        SDBFONT_ProportionalText);
    return $self;
}

sub setMinResizeBound{
    my ($self) = @_;
    $self->GetSizer()->AddSpacer(30);   #Spacer is added, because WxWidgets throws errors if the button is not entirely visible
    $self->Fit();
    $self->SetMinSize($self->GetSize());
}

1;