#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Create and draw a beautiful floorplan with steps.
#

package SDB::Install::Gui::Window::Floorplan;
use strict;
use vars qw(@ISA);
use SDB::Install::Gui::Design;
use SAPDB::Install::Resources;
use Exporter;

use Wx::Event qw( EVT_PAINT EVT_SIZE EVT_MOTION EVT_LEFT_DOWN EVT_LEFT_UP);
use SDB::Install::Gui::Event qw(SDB_EVENT_TYPE_SELECT_STEP SDB_EVENT_TYPE_SELECT_SUBSTEP SDB_EVENT_TYPE_UNTERMINATE_CLICK);


use Wx qw(
            wxWHITE_BRUSH
            wxWHITE
            wxBLACK
            wxDEFAULT
            wxNORMAL
            wxBOLD
            wxSWISS
            wxCOPY
            wxCURSOR_HAND
            wxNullCursor
         );

our $FLOORPLAN_STATUS_ACTIVE = 1;
our $FLOORPLAN_STATUS_SELECTED = 2;
our $FLOORPLAN_STATUS_HOVER = 4;

sub FLOORPLAN_STATUS_ACTIVE () {$FLOORPLAN_STATUS_ACTIVE}
sub FLOORPLAN_STATUS_SELECTED () {$FLOORPLAN_STATUS_SELECTED}
sub FLOORPLAN_STATUS_HOVER () {$FLOORPLAN_STATUS_HOVER}

our $resources = new SAPDB::Install::Resources ();

our $images = $resources->getImages (qw(
				floorplan/2nd-level-active-substep.png
				floorplan/2nd-level-active.png
				floorplan/2nd-level-hover-substep.png
				floorplan/2nd-level-hover.png
				floorplan/2nd-level-inactive-substeps.png
				floorplan/2nd-level-inactive.png
				floorplan/2nd-level-selected-substep.png
				floorplan/2nd-level-selected.png
				floorplan/active-substep.png
				floorplan/active.png
				floorplan/background.png
				floorplan/endpoint.png
				floorplan/endunknown.png
				floorplan/endunknown-hover.png
				floorplan/hover-substep.png
				floorplan/hover.png
				floorplan/inactive-substeps.png
				floorplan/inactive.png
				floorplan/line.png
				floorplan/moreafter-hover.png
				floorplan/moreafter-inactive.png
				floorplan/moreafter.png
				floorplan/morebefore-hover.png
				floorplan/morebefore-inactive.png
				floorplan/morebefore.png
				floorplan/open-2ndlevel-end.png
				floorplan/open-2ndlevel-start.png
				floorplan/open-substep-end.png
				floorplan/open-substep-start.png
				floorplan/selected-substeps.png
				floorplan/selected.png
				floorplan/startpoint.png
));

our $is_gtk1 = defined &Wx::wxGTK1 ? Wx::wxGTK1() : 0;

our $xDist = 140;

our $icon_shadow = 6;
our $icon_shadow_half = $icon_shadow / 2;

our $little_box_size = 27;
our $little_box_size_half = int ($little_box_size/2);

our $big_box_size = 31;
our $big_box_size_half = int ($big_box_size/2);

our $box_icon_size = 37;


our @substep_labels = qw (a b c d e f g h i j k l m n o p q r s t);


#our @substep_labels = qw (i ii iii iv v vi vii viii ix x);

our $mdc_bg = new Wx::MemoryDC ();
$mdc_bg->SelectObject (new Wx::Bitmap ($images->{'floorplan/background.png'}));


our $mdc_startpoint = new Wx::MemoryDC ();
$mdc_startpoint->SelectObject (new Wx::Bitmap ($images->{'floorplan/startpoint.png'}));
our ($startpointw,$startpointh) = $mdc_startpoint->GetSizeWH ();

our $mdc_morebefore = new Wx::MemoryDC ();
$mdc_morebefore->SelectObject (new Wx::Bitmap ($images->{'floorplan/morebefore.png'}));

our $mdc_morebefore_hover = new Wx::MemoryDC ();
$mdc_morebefore_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/morebefore-hover.png'}));


our $mdc_morebefore_inactive = new Wx::MemoryDC ();
$mdc_morebefore_inactive->SelectObject (new Wx::Bitmap ($images->{'floorplan/morebefore-inactive.png'}));

our $mdc_moreafter = new Wx::MemoryDC ();
$mdc_moreafter->SelectObject (new Wx::Bitmap ($images->{'floorplan/moreafter.png'}));

our $mdc_moreafter_hover = new Wx::MemoryDC ();
$mdc_moreafter_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/moreafter-hover.png'}));


our $mdc_moreafter_inactive = new Wx::MemoryDC ();
$mdc_moreafter_inactive->SelectObject (new Wx::Bitmap ($images->{'floorplan/moreafter-inactive.png'}));


our $mdc_endpoint = new Wx::MemoryDC ();
$mdc_endpoint->SelectObject (new Wx::Bitmap ($images->{'floorplan/endpoint.png'}));
our ($endpointw,$endpointh) = $mdc_endpoint->GetSizeWH ();

our $mdc_endunknown = new Wx::MemoryDC ();
$mdc_endunknown->SelectObject (new Wx::Bitmap ($images->{'floorplan/endunknown.png'}));

our $mdc_endunknown_hover = new Wx::MemoryDC ();
$mdc_endunknown_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/endunknown-hover.png'}));

our $mdc_line = new Wx::MemoryDC ();
$mdc_line->SelectObject (new Wx::Bitmap ($images->{'floorplan/line.png'}));
our ($line_width,$line_height) = $mdc_line->GetSizeWH ();


our $mdc_active = new Wx::MemoryDC ();
$mdc_active->SelectObject (new Wx::Bitmap ($images->{'floorplan/active.png'}));

our $mdc_active_hover = new Wx::MemoryDC ();
$mdc_active_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/hover.png'}));


our $mdc_active_substeps_hover = new Wx::MemoryDC ();
$mdc_active_substeps_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/hover-substep.png'}));


our $mdc_inactive = new Wx::MemoryDC ();
$mdc_inactive->SelectObject (new Wx::Bitmap ($images->{'floorplan/inactive.png'}));


our $mdc_inactive_substeps = new Wx::MemoryDC ();
$mdc_inactive_substeps->SelectObject (new Wx::Bitmap ($images->{'floorplan/inactive-substeps.png'}));

our $mdc_active_substeps = new Wx::MemoryDC ();
$mdc_active_substeps->SelectObject (new Wx::Bitmap ($images->{'floorplan/active-substep.png'}));

our $mdc_selected = new Wx::MemoryDC ();
$mdc_selected->SelectObject (new Wx::Bitmap ($images->{'floorplan/selected.png'}));


our $mdc_open_substep_start = new Wx::MemoryDC ();
$mdc_open_substep_start->SelectObject (new Wx::Bitmap ($images->{'floorplan/open-substep-start.png'}));


our $mdc_open_substep_end = new Wx::MemoryDC ();
$mdc_open_substep_end->SelectObject (new Wx::Bitmap ($images->{'floorplan/open-substep-end.png'}));

our $mdc_2level_active = new Wx::MemoryDC ();
$mdc_2level_active->SelectObject (new Wx::Bitmap ($images->{'floorplan/2nd-level-active.png'}));

our $mdc_2level_hover = new Wx::MemoryDC ();
$mdc_2level_hover->SelectObject (new Wx::Bitmap ($images->{'floorplan/2nd-level-hover.png'}));

our $mdc_2level_inactive = new Wx::MemoryDC ();
$mdc_2level_inactive->SelectObject (new Wx::Bitmap ($images->{'floorplan/2nd-level-inactive.png'}));

our $mdc_2level_selected = new Wx::MemoryDC ();
$mdc_2level_selected->SelectObject (new Wx::Bitmap ($images->{'floorplan/2nd-level-selected.png'}));



our @ISA = qw(Wx::Panel Exporter);

our @EXPORT = qw (FLOORPLAN_STATUS_ACTIVE FLOORPLAN_STATUS_SELECTED);

our (undef,$panelHeight) = $mdc_bg->GetSizeWH ();


#
# create substep background 
#

our $mdc_sub_bg;

{

	my $height = $box_icon_size - 4; 
	
	my $width = 4;

	my $sub_bg_img = new Wx::Image (new Wx::Bitmap ($width,$height));

	my $size = $width * $height;

	#
	# paint bg colour and add alpha channel (40% opacity)
	#
	
	my @alpha;

	my $t = $height - 2;
	my ($x,$y);

	foreach my $pixel (0 .. ($size -1)){
		$x = $pixel % $width;
		$y = int ($pixel / $width);

		if (($y == 1 || $y == $t) && ($x  == 0 || $x == 2)){
			#
			# dotted line
			#
			$sub_bg_img->SetRGB ($x, $y, 0x87, 0xa3, 0xc0);	
			push @alpha, 0xff;
		}
		else{
			$sub_bg_img->SetRGB ($x,$y, 0xdd, 0xe9, 0xf3);	
			push @alpha, 0x66;
		}
	}

	$sub_bg_img->SetAlpha (pack ("C$size", @alpha));
	
	$mdc_sub_bg = new Wx::MemoryDC ();

	$mdc_sub_bg->SelectObject (new Wx::Bitmap ($sub_bg_img));
}

our $disableColour = new Wx::Colour (0x99,0x99,0x99);
    
our $numberFontSelected = Wx::Font->new( 11, wxSWISS,  wxNORMAL, wxBOLD);
our $numberFontActive = Wx::Font->new( 9, wxSWISS,  wxNORMAL, wxBOLD);
our $numberFontInactive = $numberFontActive;

our $labelFontSelected = Wx::Font->new( 9, wxDEFAULT, wxNORMAL, wxBOLD,0);
our $labelFontActive = Wx::Font->new( 9, wxDEFAULT, wxNORMAL, wxNORMAL);
our $labelFontActiveHover = Wx::Font->new( 9, wxDEFAULT, wxNORMAL, wxNORMAL,1);
our $labelFontInactive = Wx::Font->new( 9, wxDEFAULT, wxNORMAL, wxNORMAL, 0);
our $labelColourActive = new Wx::Colour (0x20,0x4b,0xa2);



sub new {
  my( $class ) = shift;
  
  my( $self ) = $class->SUPER::new( @_);
   
  $self->{mdc} = new Wx::MemoryDC();
  $self->SetBackgroundColour ( wxWHITE );
  $self->{progresscounter} = 0;
  EVT_PAINT ($self, \&OnPaint);
  EVT_SIZE ($self, \&OnSize);
  EVT_MOTION ($self, \&OnMotion);
  EVT_LEFT_DOWN ($self, \&OnLeftDown);
  EVT_LEFT_UP ($self, \&OnLeftUp);
  
  my $panelWidth = $self->GetSize()->GetWidth();
  my $bitmap = Wx::Bitmap->new($panelWidth, $panelHeight);
  $self->{mdc}->SelectObject($bitmap); 
  $self->{mdc}->SetBackground ( wxWHITE_BRUSH );
  $self->SetMinSize ([-1,$panelHeight]);
  if (Wx::wxVERSION >= 3){
    $self->SetCanFocus (0);
  }
  return $self;
}


sub GetPlanWidth ($) {
	my $maxX = 60;
	
	my $i = 0;
	foreach my $step (@{$_[0]->{plan}}){
		if ($_[0]->{selected} == $i++ && scalar @$step == 3){
			
			$maxX += $xDist * (scalar @{$step->[2]} + 2);
						
		}
		else{
			$maxX += $xDist	
		}
	}
	return $maxX;
}

sub SetPlan {
	$_[0]->{plan} = $_[1];
	$_[0]->{unterminated} = $_[2];
	$_[0]->{rects} = undef;
	$_[0]->{subrects} = undef;
	$_[0]->Refresh (0);
}

sub OnSize {
    $_[0]->{mdc}->SelectObject(Wx::Bitmap->new($_[1]->GetSize()->GetWidth(), $panelHeight));
    $_[0]->Refresh(0); 
}


sub OnMotion {
    my( $self, $event ) = @_;
    
    my $point = $event->GetPosition();
	my $hand = 0;
	my $refresh = 0;
	if (!$self->IsEnabled ()){
        return 1;
    }
	if (defined $self->{rects}){
		my $step = 0;
		foreach my $rect (@{$self->{rects}}){
			if ($rect){
				if ($rect->Inside ($point)){
					if (!($self->{plan}->[$step]->[1] & $FLOORPLAN_STATUS_HOVER)){
						$self->{plan}->[$step]->[1] |= $FLOORPLAN_STATUS_HOVER;
						$refresh = 1;
					}
					
					if ($self->{plan}->[$step]->[1] & $FLOORPLAN_STATUS_ACTIVE &&
						($step != $self->{selected})){
						$hand = 1;
					}	
				}
				elsif ($self->{plan}->[$step]->[1] & $FLOORPLAN_STATUS_HOVER){
					$self->{plan}->[$step]->[1] &= ~$FLOORPLAN_STATUS_HOVER;
					$refresh = 1;
				}
			}
			$step++;
		} 
	}
	
	
	if (defined $self->{subrects}){
		my $step = 0;
		foreach my $rect (@{$self->{subrects}}){
			if ($rect){
				if ($rect->Inside ($point)){
					if (!($self->{substeps}->[$step]->[1] & $FLOORPLAN_STATUS_HOVER)){
						$self->{substeps}->[$step]->[1] |= $FLOORPLAN_STATUS_HOVER;
						$refresh = 1;
					}
					
					if (($self->{substeps}->[$step]->[1] & $FLOORPLAN_STATUS_ACTIVE) &&
						$step != $self->{selected_sub} ){
						$hand = 1;
						
					}	
				}
				elsif ($self->{substeps}->[$step]->[1] & $FLOORPLAN_STATUS_HOVER){
					$self->{substeps}->[$step]->[1] &= ~$FLOORPLAN_STATUS_HOVER;
					$refresh = 1;
				}
			}
			$step++;
		}
	}
	
	if (defined $self->{left_scroll_rect}){
		if ($self->{left_scroll_rect}->Inside ($point)){
			if (!$self->{left_scroll_hover}){
				$self->{left_scroll_hover} = 1;
				$refresh = 1;
			}
			$hand = 1;
			
		}
		elsif ($self->{left_scroll_hover}){
			$self->{left_scroll_hover} = 0;
			$refresh = 1;
		}
	}
	
	
	if (defined $self->{right_scroll_rect}){
		if ($self->{right_scroll_rect}->Inside ($point)){
			if (!$self->{right_scroll_hover}){			
				$self->{right_scroll_hover} = 1;
				$refresh = 1;
			}
			$hand = 1;
		}
		elsif ($self->{right_scroll_hover}){
			$self->{right_scroll_hover} = 0;
			$refresh = 1;
		}
	}
	
	
	if (defined $self->{unterm_rect}){
		if ($self->{unterm_rect}->Inside ($point)){
			if (!$self->{unterm_hover}){			
				$self->{unterm_hover} = 1;
				$refresh = 1;
			}
			$hand = 1;
		}
		elsif ($self->{unterm_hover}){
			$self->{unterm_hover} = 0;
			$refresh = 1;
		}
	}
	
	
	
	if ($hand){
		if (!defined $self->{restore_cursor}){
			$self->SetCursor (new Wx::Cursor (wxCURSOR_HAND));
			$self->{restore_cursor} = 1;
		}
	}
	elsif (defined $self->{restore_cursor}){
		$self->SetCursor (wxNullCursor);
		undef $self->{restore_cursor};
	}
	
	if ($refresh){
		$self->Refresh(0);
	}	 	

}


sub SetScrollPos ($$){
	my ($self,$scroll_pos) = @_;
	
	my ($width) = $self->{mdc}->GetSizeWH ();
	
	my $maxX = $self->GetPlanWidth(); 
		
	if ($scroll_pos + $maxX < $width){
			$self->{scroll_pos} = $width - $maxX; 
	}
	elsif ($scroll_pos > 0){
		$self->{scroll_pos} = 0; 
	}
	else{
		$self->{scroll_pos} = $scroll_pos; 
	}
}


sub GetScrollPos ($){
	$_[0]->{scroll_pos};
}


sub OnLeftDown {
    my( $self, $event ) = @_;
   if (!$self->IsEnabled ()){
        return 1;
    }
    my $point = $event->GetPosition ();
	
	if (defined $self->{rects}){
		my $step = 0;
		foreach my $rect (@{$self->{rects}}){
			if ($rect){
				if ($rect->Inside ($point)){
					if ($self->{plan}->[$step]->[1] & $FLOORPLAN_STATUS_ACTIVE && $step != $self->{selected}){
						$self->{left_down_index} = $step;
					} 
					return; 
				}
			}
			$step++;
		} 
	}
	
	if (defined $self->{subrects}){
		my $step = 0;
		foreach my $rect (@{$self->{subrects}}){
			if ($rect){
				if ($rect->Inside ($point)){
					if ($self->{substeps}->[$step]->[1] & $FLOORPLAN_STATUS_ACTIVE && $step != $self->{selected_sub}){
						$self->{left_down_subindex} = $step;
					} 
					return; 
				}
			}
			$step++;
		} 
	}
		
	
	if (defined $self->{left_scroll_rect}){
		if ($self->{left_scroll_rect}->Inside ($point)){
			$self->{left_scroll_left_down} = 1;
			$self->Refresh (0);
			return;
		}
		else{
			$self->{left_scroll_left_down} = 0;
		}
	}
	
	if (defined $self->{right_scroll_rect}){
		if ($self->{right_scroll_rect}->Inside ($point)){
			$self->{right_scroll_left_down} = 1;
			$self->Refresh (0);
		}
		else{
			$self->{right_scroll_left_down} = 0;
		}
	}
	
	if (defined $self->{unterm_rect}){
		if ($self->{unterm_rect}->Inside ($point)){
			$self->{unterm_left_down} = 1;
			$self->Refresh (0);
		}
		else{
			$self->{unterm_left_down} = 0;
		}
	}
}


sub OnLeftUp {
    my( $self, $event ) = @_;
	if (!$self->IsEnabled ()){
        return 1;
    }
    my $point = $event->GetPosition ();
    if (defined $self->{left_down_index}){
		if (defined $self->{rects}->[$self->{left_down_index}]){
			if ($self->{rects}->[$self->{left_down_index}]->Inside ($point)){
				my $evt = new Wx::CommandEvent (SDB_EVENT_TYPE_SELECT_STEP, $self->GetId);
				$evt->SetInt ($self->{left_down_index});
				$evt->SetString ($self->{plan}->[$self->{left_down_index}]->[0]);	
				Wx::PostEvent($self, $evt);
			}
		}
		undef $self->{left_down_index};
    }
    
    if (defined $self->{left_down_subindex}){
		if (defined $self->{subrects}->[$self->{left_down_subindex}]){
			if ($self->{subrects}->[$self->{left_down_subindex}]->Inside ($point)){
				my $evt = new Wx::CommandEvent (SDB_EVENT_TYPE_SELECT_SUBSTEP, $self->GetId);
				$evt->SetInt ($self->{left_down_subindex});
				$evt->SetString ($self->{substeps}->[$self->{left_down_subindex}]->[0]);	
				Wx::PostEvent($self, $evt);
			}
		}
		undef $self->{left_down_index};
    }
    
    if (defined $self->{unterm_left_down}){
		if (defined $self->{unterm_rect} && $self->{unterm_rect}->Inside ($point)){
				my $evt = new Wx::CommandEvent (SDB_EVENT_TYPE_UNTERMINATE_CLICK, $self->GetId);
				Wx::PostEvent($self, $evt);	
		}
		undef $self->{unterm_left_down};
    }
    
    
    if (defined $self->{right_scroll_left_down}){
		undef $self->{right_scroll_left_down};
	}

	if (defined $self->{left_scroll_left_down}){
		undef $self->{left_scroll_left_down};
	}
}



sub OnPaint {
    my( $self, $event ) = @_;

    #
    #   Initialisation
    #
    
    my( $dc ) = Wx::PaintDC->new( $self );
    
    my $progresscounter = $self->{progresscounter};    
    my $mdc = $self->{mdc};
    
    $mdc->Clear();
    
    
	my ($panelWidth) = $mdc->GetSizeWH ();       
 
    

	#
	# calculate size
	#
  
	my $maxX = $self->GetPlanWidth ();
	

  	#
	# paint background
	#    
    
    foreach my $col (0 .. $panelWidth - 1){
		$mdc->Blit ($col,0,1,$panelHeight,$mdc_bg,0,0,wxCOPY,1);
    }   

    #
    #   horizont line
    #
    
    my $max = $maxX;
    
    if ($maxX > $panelWidth){
		if (!defined $self->{scroll_pos}){
			$self->{scroll_pos} = 0;
		}
		else{
			if ($self->{scroll_pos} - $panelWidth + $maxX < 0){
				$self->{scroll_pos} = $panelWidth - $maxX; 
			} 
		}
		$max = $panelWidth;
    }
    else{
		undef $self->{scroll_pos};
	}
	
	my $scroll_pos = $self->{scroll_pos};
    
    
    my $endpos = $max - 26;
	
	my $i = 33;
	my $w;
	
	while (1){
		if (($endpos - $i - 7) < $line_width){
			$w = $endpos - $i - 7;
		}
		else{
			$w = $line_width;
		}
		$mdc->Blit ($i,29,$w,$line_height,$mdc_line,0,0,wxCOPY,1);
	
		if ($w < $line_width){
			last;
		}
		$i += $line_width;
	}	
	
   my $xPos = 30;
   

	#
    #   start and end point
    #

	my ($start_mdc,$end_mdc);
	
	if (defined $scroll_pos){
		
		if ($scroll_pos >= 0){
			$start_mdc = $mdc_morebefore_inactive;
		}
		else{
			if ($self->{left_scroll_hover}){
				$start_mdc = $mdc_morebefore_hover;
			}
			else{
				$start_mdc = $mdc_morebefore;
			}
		}
		
		if ($scroll_pos + $maxX - $max <= 0){
			$end_mdc = $mdc_moreafter_inactive;
		}
		elsif ($self->{right_scroll_hover}){
			$end_mdc = $mdc_moreafter_hover;
		}
		else{
			$end_mdc = $mdc_moreafter;
		}
		
	}
	else{
		$start_mdc = $mdc_startpoint;
		if ($self->{unterminated}){
			if ($self->{unterm_hover}){
				$end_mdc = $mdc_endunknown_hover;
			}
			else{
				$end_mdc = $mdc_endunknown;
			}
		}
		else{
			$end_mdc = $mdc_endpoint;
		}
		
		
	}
	
	my ($startw, $starth) = $start_mdc->GetSizeWH ();
	my ($endw, $endh) = $end_mdc->GetSizeWH ();
	
	my @coords = (26 - int ($startw/2),23,$startw, $starth);
	
	$mdc->Blit (@coords,$start_mdc,0,0,wxCOPY,1);
	
	if (defined $scroll_pos && $scroll_pos < 0){
		$self->{left_scroll_rect} = new Wx::Rect (@coords);
	}
	else{
		undef $self->{left_scroll_rect};
	}
	
	@coords = ($endpos - int ($endw/2) ,23,$endw, $endh);
		  
	$mdc->Blit (@coords,$end_mdc,0,0,wxCOPY,1);
	
	if (defined $scroll_pos && $scroll_pos + $maxX - $max > 0){
		$self->{right_scroll_rect} = new Wx::Rect (@coords);
	}
	else{
		undef $self->{right_scroll_rect};
	
		if ($self->{unterminated}){
			$self->{unterm_rect} = new Wx::Rect (@coords);
		}
		else{
			undef $self->{unterm_rect};
		}
	}
	
    #
    #   Steps
    #
    
    my $n = 0;
    
    my $step_mdc;
    my ($yDist,$yPos, $numberFont,$textFont,$textColour,$tw,$th, $numberColour, $xCentre);
    
    $xPos += $xDist / 2;
    
    my @rects;
    
    my $boxsize;
   
	
	my $substeps;
	
	$self->{substeps} = undef;
	$self->{subrects} = undef;
	
   
	foreach my $step (@{$self->{plan}}) {
	
		$substeps = undef;
	
		if (($xPos + (defined $scroll_pos ? ($xDist/4 + $scroll_pos) : ($xDist/2)))  > $endpos){
			last;
		}
		
		my $text = $step->[0];
       if ($self->{selected} == $n){
			if (scalar @$step == 3){
				$substeps = $step->[2];
				$yDist = 13;
				$textFont =  $labelFontActive;
				$textColour = $labelColourActive;
				$numberColour = wxBLACK;
				$numberFont =  $numberFontActive;
				$step_mdc = $mdc_open_substep_start;
			}
			else{
				$boxsize = $big_box_size;   
				$yDist = 13;
				$step_mdc = $mdc_selected;
				$numberFont =  $numberFontSelected;
				$textFont =  $labelFontSelected;
				$numberColour = wxBLACK;
				$textColour = wxBLACK;
			}
       }
       elsif ($step->[1] & $FLOORPLAN_STATUS_ACTIVE){
			$yDist = 13;
						
			$numberColour = wxBLACK;
			$numberFont =  $numberFontActive;
			
			if ($step->[1] & $FLOORPLAN_STATUS_HOVER){
				$boxsize = $big_box_size;
				if (scalar @$step == 3){
					$step_mdc = $mdc_active_substeps_hover;
				}
				else{
					$step_mdc = $mdc_active_hover;
				}
				$textFont =  $labelFontActiveHover;
			}
			else{
				$boxsize = $little_box_size;
				if (scalar @$step == 3){
					$step_mdc = $mdc_active_substeps;
				}
				else{
					$step_mdc = $mdc_active;
				}
				$textFont =  $labelFontActive;
			}
			$textColour = $labelColourActive;
       }	
       else{
			$boxsize = $little_box_size;
			$yDist = 13;
			if (scalar @$step == 3){
				$step_mdc = $mdc_inactive_substeps;
			}
			else{
				$step_mdc = $mdc_inactive;
			}
			$numberColour = $disableColour;
			$numberFont =  $numberFontInactive;
			$textFont =  $labelFontInactive;
			$textColour = $disableColour;
       }
       
       my $add_scroll_pos = 0;
       if (defined $scroll_pos){
            $add_scroll_pos = $scroll_pos;
       }
       
       if ($xPos - $xDist/2 + $add_scroll_pos >= 0){
			       
			$yPos = $yDist;
         
            
			#
			#    regular boxes
			#
       
       
			@coords = ($xPos - int($box_icon_size/2) + $add_scroll_pos, $yPos,$box_icon_size, $box_icon_size);
       
       
			push @rects, new Wx::Rect (@coords);
			$mdc->Blit( @coords, $step_mdc, 0,0,wxCOPY,1);
       
       
              
			#
			#    Number
			#
       
			$mdc->SetTextForeground($numberColour);
			$mdc->SetFont($numberFont) if (!$is_gtk1);
       
			($tw,$th) = $mdc->GetTextExtent ($n+1);
      
             
       
			$mdc->DrawText( ($n+1), $xPos - $tw/2  + $add_scroll_pos, 30 - ($th/2) );
              
			#
			#    Text
			#
       
			$yPos += $box_icon_size + $yDist; 
       
			$mdc->SetTextForeground($textColour);
			$mdc->SetFont($textFont) if (!$is_gtk1);
       
			my ($line,$rest,$tmp) = ($text,'');
       
			while (1){
				($tw,$th ) = $mdc->GetTextExtent ($line);
				if ($tw > ($xDist - 5) and ($line =~ /\s/)){
					($line,$tmp) = ($line =~ /(.*)\s(\S*)$/);
					if ($rest){
						$rest = $tmp . ' ' . $rest;
					}
					else{
						$rest = $tmp;
					}
				}
				else{
					$mdc->DrawText( $line, $xPos - $tw/2  + $add_scroll_pos, $yPos);
					if (!$rest){
						last;
					}
					$line = $rest;
					$rest = '';
					$yPos += int ($th * 1.2);
				}
			}	
        }
        else{
			push @rects,undef;
		}
        
        
        $xPos += $xDist;
        
        
		if (defined $substeps){
			
			$self->{substeps} = $substeps;
			
			#
			#	substeps
			#
								
			my $startx_bg = $xPos + int($box_icon_size/2) + $add_scroll_pos - $xDist;
					
			if ($startx_bg - $xDist/2 - 4 < 0){
				$startx_bg = $xDist/2;
			}
			
			
			my $offset = $startx_bg - 4;
			
					
			my $end = $xDist * (scalar @$substeps) + $xPos  + $box_icon_size/2;
			my $endx_bg = $end - 7 + $add_scroll_pos;
			
			my $y = 13;
			$yPos = $yDist;
			
			while (1){
				last if ($offset > $endx_bg || $offset > $endpos - $box_icon_size/2);
				$mdc->Blit ($offset - 2,$y, 4, $box_icon_size - 4,$mdc_sub_bg,0,0,wxCOPY,1);
				$offset += 4;
			}
			
			my $m = 0;
			my @subrects;			
			
			foreach my $substep (@$substeps){
			
				if (($xPos + (defined $scroll_pos ? ($xDist/4 + $scroll_pos) : ($xDist/2)))  > $endpos){
					last;
				}
		
				if ($xPos - $xDist/2 + $add_scroll_pos < 0){
					$m++;
					push @subrects,undef;
					$xPos += $xDist; 
					next;
				}
			
			
						
				if ($self->{selected_sub} == $m){
					$boxsize = $big_box_size;   
					$yDist = 13;
					$step_mdc = $mdc_2level_selected;
					$numberFont =  $numberFontSelected;
					$textFont =  $labelFontSelected;
					$numberColour = wxBLACK;
					$textColour = wxBLACK;	
				
				}
				elsif($substep->[1] & $FLOORPLAN_STATUS_ACTIVE){
					$yDist = 13;
						
					$numberColour = wxBLACK;
					$numberFont =  $numberFontActive;
			
					if ($substep->[1] & $FLOORPLAN_STATUS_HOVER){
						$boxsize = $big_box_size;
						$step_mdc = $mdc_2level_hover;
						$textFont =  $labelFontActiveHover;
					}
					else{
						$boxsize = $little_box_size;
						$step_mdc = $mdc_2level_active;
						$textFont =  $labelFontActive;
					}
					$textColour = $labelColourActive;
				
				}
				else{
					$boxsize = $little_box_size;
					$yDist = 13;
					$step_mdc = $mdc_2level_inactive;
					$numberColour = $disableColour;
					$numberFont =  $numberFontInactive;
					$textFont =  $labelFontInactive;
					$textColour = $disableColour;
				}
					
				$yPos = $yDist;
			
			
				#
				#    sub step boxes
				#
       
       
				@coords = ($xPos - int($box_icon_size/2) + $add_scroll_pos, $yPos,$box_icon_size, $box_icon_size);
       
       
				push @subrects, new Wx::Rect (@coords);
	    		$mdc->Blit( @coords, $step_mdc, 0,0,wxCOPY,1);
       
       
              
	    		#
				#    substep character
				#
       
				$mdc->SetTextForeground($numberColour);
				$mdc->SetFont($numberFont) if (!$is_gtk1);
       
				($tw,$th) = $mdc->GetTextExtent ($substep_labels[$m]);
      
             
       
				$mdc->DrawText( $substep_labels[$m], $xPos - $tw/2  + $add_scroll_pos, 30 - ($th/2) );
              
				#
				#    substep text
				#
       
       
			    my $text = $substep->[0];
       
				$yPos += $box_icon_size + $yDist; 
       
				$mdc->SetTextForeground($textColour);
				$mdc->SetFont($textFont) if (!$is_gtk1);
       
				my ($line,$rest,$tmp) = ($text,'');
       
				while (1){
					($tw,$th ) = $mdc->GetTextExtent ($line);
					if ($tw > ($xDist - 5) and ($line =~ /\s/)){
						($line,$tmp) = ($line =~ /(.*)\s(\S*)$/);
						if ($rest){
							$rest = $tmp . ' ' . $rest;
						}
						else{
							$rest = $tmp;
						}
					}
					else{
						$mdc->DrawText( $line, $xPos - $tw/2  + $add_scroll_pos, $yPos);
						if (!$rest){
							last;
						}
						$line = $rest;
						$rest = '';
						$yPos += int ($th * 1.2);
					}
				}
				$xPos += $xDist; 
				$m++;			
			}		
		
			if (($xPos + (defined $scroll_pos ? ($xDist/4 + $scroll_pos) : ($xDist/2)))  < $endpos && $xPos - $xDist/2  >= 0){
				$mdc->Blit ($xPos - int($box_icon_size/2) + $add_scroll_pos, $yDist,$box_icon_size, $box_icon_size,$mdc_open_substep_end,0,0,wxCOPY,1);
			}
			$self->{subrects} = \@subrects;
			$xPos += $xDist; 
		}
		$n++;
	
	}
    
    $self->{rects} = \@rects;
    
    $dc->Blit(0, 0, $panelWidth, $panelHeight, $mdc, 0, 0); # Copy
    
    if (defined $scroll_pos && $scroll_pos < 0 && $self->{left_scroll_left_down}){
		$self->{scroll_pos} += 2;
		$self->Refresh (0);
		if ($is_gtk1){
			while (Wx::wxTheApp->Pending) {Wx::wxTheApp->Dispatch ();}
			$self->Update ();
		}	
    }
    
    if (defined $scroll_pos && $scroll_pos + $maxX - $max >= 0 && $self->{right_scroll_left_down}){
		$self->{scroll_pos} -= 2;
		$self->Refresh (0);
		if ($is_gtk1){
			while (Wx::wxTheApp->Pending) {Wx::wxTheApp->Dispatch ();}
			$self->Update ();
		}
    }
   
    return 1;
}

#
# Enable or disable Floorplan steps
#    $number from 0 to n - 1
#    $enable = 1 or 0
#

sub setEnable {
    my ($self, $number, $enable) = @_;
    
    my $step = $self->{plan}->[$number];
    
   	if (!defined $step){
		return 0;
	}
		
    
	if (!defined $enable || $enable){
		if (! ($step->[1] & $FLOORPLAN_STATUS_ACTIVE)){
			$step->[1] |= $FLOORPLAN_STATUS_ACTIVE;
			$self->Refresh (0);
		}
	}
	else{
		if (($step->[1] & $FLOORPLAN_STATUS_ACTIVE)){
			$step->[1] &= ~$FLOORPLAN_STATUS_ACTIVE;
			$self->Refresh (0);
		}
	}
    1;
}


#
# Enable or disable Floorplan steps
#    $number from 0 to n - 1
#    $enable = 1 or 0
#

sub setEnableSub {
    my ($self, $number,$subnumber, $enable) = @_;
    
    if (!defined $self->{plan}->[$number] || scalar @{$self->{plan}->[$number]} < 3){
		return 0;
    }
    
    my $step = $self->{plan}->[$number]->[2]->[$subnumber];
	
	
		if (!defined $step){
		return 0;
	}
	
	my $refresh = 0;
		
    if (!defined $enable || $enable){
		if (! ($step->[1] & $FLOORPLAN_STATUS_ACTIVE)){
			$step->[1] |= $FLOORPLAN_STATUS_ACTIVE;
			$refresh = 1;
		}
		
		if (! ($self->{plan}->[$number]->[1] & $FLOORPLAN_STATUS_ACTIVE)){
			$self->{plan}->[$number]->[1] |= $FLOORPLAN_STATUS_ACTIVE;
			$refresh = 1;
		}
		
		
	}
	else{
		if ($step->[1] & $FLOORPLAN_STATUS_ACTIVE){
			$step->[1] &= ~$FLOORPLAN_STATUS_ACTIVE;
			$refresh = 1;
		}
		
		my $all_inactive = 1;
		
		foreach $step (@{$self->{plan}->[$number]->[2]}){
			if ($step->[1] & $FLOORPLAN_STATUS_ACTIVE){
				$all_inactive = 0;
				last;
			}
		}
		
		if ($all_inactive && ($self->{plan}->[$number]->[1] | $FLOORPLAN_STATUS_ACTIVE)){
			$self->{plan}->[$number]->[1] &= ~$FLOORPLAN_STATUS_ACTIVE;
			$refresh = 1;
		}
		
	}
	
	if ($refresh){
		$self->Refresh (0);
	}
	
    1;
}


sub GetStepPosition{
	my ($self,$num) = @_;
	
	my $x = 60 + $xDist * $num;
		
	if ($self->{selected} < $num && scalar @{$self->{plan}->[$self->{selected}]} == 3){
		$x += ($xDist * (scalar @{$self->{plan}->[$self->{selected}]->[2]} + 1));
	}
	
	return $x;
}

sub GetSubStepPosition{
	my ($self,$num,$subnum) = @_;
	return (60 + $xDist * ($num + $subnum + 1));
}



#
# select floorplan steps
# $number from 0 to n-1
#

sub selectStep {
    my ($self, $number) = @_;
	
	if (!defined $self->{plan}->[$number]){
		return 0;
	} 

	if (defined $self->{selected} && $self->{selected} == $number){
		return 1;
	}

	my $step = $self->{plan}->[$number];
	
	$self->{selected} = $number;
	
	
	my ($width) = $self->{mdc}->GetSizeWH ();
	
	my $maxX = $self->GetPlanWidth(); 
	
	if ($maxX > $width){
		
		my $scroll_pos = $self->GetScrollPos ();
        if (!defined $scroll_pos){
            $scroll_pos = 0;
        }
		
		my $pos = $self->GetStepPosition ($number);
		
		#
		# scroll selected step into visible area
		#	
		
		my $border = int ($width / 3);
		if (($pos + $scroll_pos) < $border || ($pos + $scroll_pos) > ($width - $border)){
			my $scrollPosition = int ($width / 2) - $pos;
			$scrollPosition = $scrollPosition > 0 ? $scrollPosition : -1*$scrollPosition;
			$self->SetScrollPos  ($scrollPosition);
		}
	}	
	
	
	$self->Refresh (0);
	return 1;
}


#
# select floorplan sub steps
# $number from 0 to n-1
#

sub selectSubStep {
    my ($self, $number, $subnumber) = @_;
    
    
    if (!defined $number){
		$number = $self->{selected};
	}
	
	if (!defined $number || !defined $subnumber){
		return 0;
	}
	
	if (!defined $self->{plan}->[$number]){
		return 0;
	}
	
	if (scalar @{$self->{plan}->[$number]} != 3){
		return 0;
	}
	
	if (!defined $self->{plan}->[$number]->[2]->[$subnumber]){
		return 0;
	}
	
	if ($self->{selected} == $number && $self->{selected_sub} == $subnumber){
		return 1;
	} 
	
	$self->{selected} = $number;
	$self->{selected_sub} = $subnumber;
	
	
	my ($width) = $self->{mdc}->GetSizeWH ();
	
	my $maxX = $self->GetPlanWidth(); 
	
	if ($maxX > $width){
		
		my $scroll_pos = $self->GetScrollPos ();
		
		my $pos = $self->GetSubStepPosition ($number,$subnumber);
		
		#
		# scroll selected step into visible area
		#	
		
		my $border = int ($width / 3);
		
		if (!defined $scroll_pos){
			$scroll_pos = 0;
		}

		if (($pos + $scroll_pos) < $border || ($pos + $scroll_pos) > ($width - $border)){
		
			$self->SetScrollPos (int ($width / 2) - $pos);
		}
	}	
			
	$self->Refresh (0);
	return 1;
}

1;
