#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Official super SAP Banner for the wizard.
#

package SDB::Install::Gui::Window::SAPBanner;

use vars qw(@ISA);

use Wx qw(
            wxBLACK_PEN
            wxWHITE_BRUSH
            wxWHITE
            wxNO_FULL_REPAINT_ON_RESIZE
            wxNullBitmap
            wxDEFAULT
            wxNORMAL
            wxBOLD
            wxSWISS
         );

use Wx::Event qw( EVT_PAINT EVT_SIZE );

use SAPDB::Install::Resources;
         
         
@ISA = qw(Wx::Panel);

our ($bmp_banner_middle,$bmp_banner_left,$bmp_banner_right);


our $panelHeight; #


sub new {
  my( $class ) = shift;
  
  my( $this ) = $class->SUPER::new(@_);
   
    {   
        my $resources = new SAPDB::Install::Resources();
        my $images = $resources->getImages (qw (
                        banner/banner_left.png
                        banner/banner_middle.png
                        banner/banner_right.png 
                    ));
      $bmp_banner_left = Wx::Bitmap->new($images->{'banner/banner_left.png'});
      $bmp_banner_right = Wx::Bitmap->new($images->{'banner/banner_right.png'});
      $bmp_banner_middle = Wx::Bitmap->new($images->{'banner/banner_middle.png'});
    }
  $panelHeight = $bmp_banner_left->GetHeight(); #
  $this->SetMinSize ([-1,$panelHeight]);

  $this->{mdc} = Wx::MemoryDC->new();
    
  #
  # Events
  #
  
  EVT_PAINT ($this, \&OnPaint);
  EVT_SIZE ($this, \&OnSize);
  if (Wx::wxVERSION >= 3){
    $this->SetCanFocus (0);
  }
  return $this;
}

sub OnSize {
    my( $this, $event ) = @_;
	$this->{mdc}->SelectObject( Wx::Bitmap->new($_[1]->GetSize()->GetWidth(), $panelHeight));  
    $this->Refresh(0);
}

sub OnPaint {
    my( $this, $event ) = @_;

    #
    #   Initialisation
    #
  
    my $mdc = $this->{mdc};  
    my ($panelWidth) = $mdc->GetSizeWH ();
    my $minpos = $bmp_banner_left->GetWidth();
    my $maxpos = $panelWidth - ($bmp_banner_right->GetWidth());
    
    my $dc  = Wx::PaintDC->new( $this );
  
    
    #
    #   Put Images
    #
    
    for (my $xCount = $minpos; $xCount < $maxpos; $xCount++ ) {
            $mdc->DrawBitmap($bmp_banner_middle, $xCount, 0,0);
    }
    
    $mdc->DrawBitmap($bmp_banner_left, 0, 0,0);
    
    
    $mdc->DrawBitmap($bmp_banner_right, $maxpos , 0,0);
    
    #
    #   Finish
    #
    
    $dc->Blit(0, 0, $panelWidth, $panelHeight, $mdc, 0, 0); # Copy
    return 1;
}

1;
