package SDB::Install::HdbMounter;

use base SDB::Install::PythonExecutor;
use SDB::Install::SysVars;
use SDB::Install::System qw (makedir);

our $script = 'hdbmount.py';

#
# 1st arg is the directory containing the mount script
#
sub new{
    my $self = shift->SUPER::new();
    $self->setScript ($_[0] . $path_separator . $script);
    $self->{uid} = $_[1];
    $self->{gid} = $_[2];
    return $self;
}

sub setParams{
   my $self = shift;
   ($self->{ini}, $self->{data}, $self->{log}, $self->{sid}, $self->{storage_partition}) = @_;
}

sub mount{
    my ($self)  = @_;

    if ($self->{mounted}){
        return 1;
    }

    my @createdDirs;
    $self->{createdDirs} = \@createdDirs;

    foreach my $mountPoint ($self->{data},$self->{log}){
        if (!-d $mountPoint){
            my $msg = $self->AddMessage ("Creating mount point '$mountPoint'");
            my $cfg = {'listCreated' => []};
            if (!makedir ($mountPoint,$cfg)){
                $self->AddError ("Cannot create mount point '$mountPoint': ",$cfg);
                return undef;
            }
            $self->AddSubMsgLst ($msg, $cfg);
            push @createdDirs, @{$cfg->{listCreated}};
        }
        else{
            $self->AddMessage ("Mount point '$mountPoint' already exists");
        }
    }
    $self->{mounted} = 1;
    return $self->runScript ([
    "--sid=$self->{sid}",
    "--configFiles=$self->{ini}",
    "--datapath=$self->{data}",
    "--logpath=$self->{log}",
    defined $self->{storage_partition} ?
        "--partition=$self->{storage_partition}" : ()
    ], $self->{uid}, $self->{gid});
}


sub umount{
    my ($self)  = @_;
    if (!$self->{mounted}){
        return 1;
    }
    my $rc = $self->runScript ([
    "--sid=$self->{sid}",
    "--configFiles=$self->{ini}",
    "--datapath=$self->{data}",
    "--logpath=$self->{log}",
    '--detach',
    defined $self->{storage_partition} ?
        "--partition=$self->{storage_partition}" : ()], $self->{uid}, $self->{gid});

    foreach my $dir (reverse @{$self->{createdDirs}}){
        if ($dir && -d $dir){
            my $msg = $self->AddMessage ("Removing created mount points");
            if (!rmdir ($dir)){
                $self->AddError ("Cannot remove directory '$dir': $!");
                $rc = undef;
            }
            else{
                $self->AddSubMessage ($msg, "Directory '$dir' removed");
            }
        }
    }
    $self->{mounted} = 0;
    return $rc;
}

sub DESTROY{
    #$_[0]->umount ();
}

1;
