package SDB::Install::Installation::GenericServerPlugin;

use SDB::Install::Installation::Generic;
use SDB::Install::Globals qw ($gSapsysGroupName);
use SDB::Install::SysVars qw ($path_separator $re_path_separator $isWin);
use SDB::Install::System qw (deltree);
use SDB::Install::SAPSystem qw (CollectSAPSystems);
use SDB::Install::NewDBUser;
#use SDB::Install::DebugUtilities qw (dumpThings);
use Cwd qw (abs_path);
use strict;

our @ISA = qw (SDB::Install::Installation::Generic);

sub init{
	my $self = shift;

	if (!$isWin && -l $self->{path}){
		$self->getMsgLst()->addMessage ("Plugin path '$self->{path}' is a symbolic link, using link target '" . abs_path ($self->{path}) . "' instead");
		$self->{path} = abs_path($self->{path});
	}
	my $rc = $self->SUPER::init (@_);
	return $rc;
}

sub getSystem{
	my ($self) = @_;

	my $instconfig = $self->getConfiguration ();
	if ($instconfig) {
		my $system = $instconfig->getSystem();
		if ($system) {
			return $system;
		}
	}
	my $path;
	my @matches;
	if ($isWin){
		$path = $self->GetInstallationPath ();
		@matches = ($path =~ /$re_path_separator([A-Z][A-Z0-9][A-Z0-9])${re_path_separator}(?:SYS|HDB\d\d)${re_path_separator}exe$re_path_separator/ig);
	}
	else{
		$path = abs_path ($self->GetInstallationPath ());
		@matches = ($path =~ /$re_path_separator([A-Z][A-Z0-9][A-Z0-9])${re_path_separator}exe$re_path_separator/g);
	}

	my $sid = pop @matches;
	if (!$sid){
		return undef;
	}

	if ($isWin){
		$sid = uc ($sid);
	}
	my $systems = CollectSAPSystems ();
	return $systems->{$sid};
}

sub getUID {
	my ($self) = @_;
	my $system = $self->getSystem();
	if (defined $system) {
		return $system->getUID();
	} else {
		return undef;
	}
}

sub getGID {
	my ($self) = @_;
	my $system = $self->getSystem();
	if (defined $system) {
		return $system->getGID();
	} else {
		return undef;
	}
}

sub getExecuteCommandsAtActivation{
	my ($self) = @_;
	if (!defined $self->{_ExecuteCommandsAtActivation}){
		my $configparser = $self->getConfigParser ();
		if (! defined $configparser){
			return undef;
		}
		my $cmds = $configparser->getExecuteCommandsAtActivation();
		if (!defined $cmds){
			return undef;
		}
		$self->{_ExecuteCommandsAtActivation} = $cmds;
	}
	return $self->{_ExecuteCommandsAtActivation};
}

sub getReplaceHash{

	my ($self) = @_;

	if (!$self->getSystem()) {
		return {};
	}

	return {'%(InstallationPath)' => $self->GetInstallationPath (),
			'%(SID)' => $self->getSystem()->get_sid(),
			'%(InstanceNumber)' => $self->getSystem()->getNewDBInstanceNr(),
			'%(User)' => $self->getSystem()->getUser()->getSidAdmName(),
			'%(Group)' => $gSapsysGroupName
	};
}

sub setInstallationPath{

	$_[0]->{path} = $_[1];
	$_[0]->{registrypath} = $_[1] . $path_separator . 'install';
}

sub Uninstall{
	my $self = shift;
	my (undef, $force, $instconfig, $update) = @_;

	my $system = $self->getSystem();
	my $instance = $system->getNewDBInstances()->[0];

	my $prefix = $self->getProductKey() . '_';
	my $systemPluginDir = $system->get_pluginsDir();
	my $path;

	# stat active plugin, for comparison with other versions
	my @inst_statbuf = stat($self->{'path'});

	if (!$isWin) {
		# delete symlink from instance exe dir to plugin
		my $link = $instance->get_pluginsDir() . $path_separator . $self->getProductKey();
		if (!-e $link){
			$self->getMsgLst()->addMessage ("Symbolic link '$link' does not exist");
		} else {
			if (!-l $link){
				$self->getMsgLst()->addMessage ("'$link' is not a symbolic link and will not be deleted");
			} else {
				if (!unlink ($link)){
					$self->setErrorMessage ("Cannot delete symbolic link '$link'");
					return undef;
				} else {
					$self->getMsgLst()->addMessage ("Symbolic link '$link' deleted");
				}
			}
		}

		# delete symlinks to old/new versions of plugin in system exe dir
		my $oldlink = $systemPluginDir . $path_separator . $prefix . 'old';
		my $newlink = $systemPluginDir . $path_separator . $prefix . 'new';
		foreach $link ($oldlink, $newlink) {
			if (!-e $link){
				$self->getMsgLst()->addMessage ("Symbolic link '$link' does not exist");
			} else {
				if (!-l $link){
					$self->getMsgLst()->addMessage ("'$link' is not a symbolic link and will not be deleted");
				} else {
					if (!unlink ($link)){
						$self->setErrorMessage ("Cannot delete symbolic link '$link'");
						return undef;
					}
				}
			}
		}
	}

	# delete directories of all other versions of this plugin
	if(!opendir (SPDIR, $systemPluginDir)) {
		$self->setErrorMessage ("Cannot open directory '$systemPluginDir'");
		return undef;
	}
	my $errlst = new SDB::Install::MsgLst;
	while(my $entry = readdir (SPDIR)) {
		if($entry =~ /^\.\.?$/) {
			next;
		}
		$path = $systemPluginDir . $path_separator . $entry;
		if (-l $path) {
			next;
		}
		my @statbuf = stat($path);
		if ($statbuf[0] == $inst_statbuf[0] && $statbuf[1] == $inst_statbuf[1]) {
			# this is our own version, it will be uninstalled by base class uninstall
			next;
		}
		if ($entry =~ /^$prefix/ && -d $path) {
			if (!deltree ($path, $errlst)) {
				$self->setErrorMessage ("Cannot delete directory '$path'", $errlst);
				return undef;
			} else {
				$self->getMsgLst()->addMessage ("Deleted directory '$path'");
			}
		}
	}

	# Call base class uninstall if this is not an update

	my $rc;
	if (!$update) {
		$rc = $self->SUPER::Uninstall (@_);
		if (!defined $rc) {
			return $rc;
		}
	}

	return $rc;
}

sub Register {
	return 1;
}

sub Unregister {
	return 1;
}

1;
