package SDB::Install::InstallationEventHandler;

use base SDB::Install::Base;

use strict;

sub setInstConfig{
    $_[0]->{instconfig} = $_[1];
}

sub setInstallation{
    $_[0]->{installation} = $_[1];
}


sub getInstConfig{
    return $_[0]->{instconfig};
}

sub getKit{
    if (defined $_[0]->{instconfig} && defined $_[0]->{instconfig}->{kit}){
        return $_[0]->{instconfig}->{kit};
    }
    return undef;
}

sub getInstallation{
    if (defined $_[0]->{installation}){
        return $_[0]->{installation};
    }
    my $kit = $_[0]->getKit ();
    if (defined $kit){
        return $kit->getInstallation ();
    }
    return undef;
}


sub triggerEvent{
    my ($self, $event, $msglst, $errlst) = @_;
    my $func = $self->can ($event);
    if (!defined $func){
        $msglst->addMessage ("No $event event handler defined");
        return 1;
    }

   # execute custom event
   my $eventRc = 1;
   $errlst->initMsgLst();
   my $msg = $msglst->addMessage ("Calling $event event handler");
   $self->setMsgLstContext([$msg->getSubMsgLst(), $errlst]);
    eval{
        $eventRc = &{$func} ($self);
    };

    if ($@){
        $self->setErrorMessage ("Cannot execute custom event $event: $@");
        return undef;
    }
    if (!defined $eventRc || !$eventRc && $errlst->isEmpty()){
        $self->setErrorMessage ("Custom event $event failed", $errlst);
    }
    $msg->endMessage (undef, "$event event handler");
    return $eventRc;
}



#####################################################################
#
#  event handler methods
#

sub preInstall{
    return 1;
}

sub postInstall{
    return 1;
}

sub preCheck{
    return 1;
}

sub postCheck{
    return 1;
}

sub preUninstall{
    return 1;
}

sub postUninstall{
    return 1;
}

sub getFinalMessage{
    return undef;
}

1;
