#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Type filter class to filtering for _TYPE attributes.

package SDB::Install::LogViewer::Filter::TypeFilter;

use strict;

use vars qw(@ISA);

use SDB::Install::LogViewer::Filter::AbstractFilter;

our @ISA = qw (SDB::Install::LogViewer::Filter::AbstractFilter);

my $CAT = '_TYPE'; # this attribute is program


##
# Constructor for initialization.
##

sub new{
	my($self ) = shift->SUPER::new();
	
	$self->{RequireOrExclude} = shift;
    $self->{TypeName} = shift;   
    
	return $self;
}


##
# This method checks the current tree item
# for destroying. This method knows no pain.
#
# @param
#   TreeEmelent item - item to check
#   CacheTree cacheTree - Cache Tree
##

sub CheckAndKill () {
   my ($self, $item, $cacheTree) = @_;
   if ( defined $item){
        my $data = $cacheTree->GetPlData($item);
        if ($self->{TypeName} ne 'Info (default)') {
            if ($self->{RequireOrExclude} eq 'Require') {
                if (defined $data->{$CAT}) {
                    if ($data->{$CAT} ne $self->{TypeName} ) {
                        $data->{filter} = 'Exclude';
                    }
                } else {
                    $data->{filter} = 'Exclude';
                }
            } elsif($self->{RequireOrExclude} eq 'Exclude') {
               if (defined $data->{$CAT}) {
                    if ($data->{$CAT} eq $self->{TypeName} ) {
                        $data->{filter} = 'Exclude';
                    } 
                } 
            }
        } else {
           if ($self->{RequireOrExclude} eq 'Exclude') {
                unless (defined $data->{$CAT}) {
                    $data->{filter} = 'Exclude';
                }
            } elsif($self->{RequireOrExclude} eq 'Require') {
               if (defined $data->{$CAT}) {
                    $data->{filter} = 'Exclude';
                } 
            }
        }
        $cacheTree->SetPlData($item, $data);
    }
    1;
}


##
# Get the category.
#
# @return
#   scalar category
##

sub GetCatergory(){
    my ($self)=@_;
    return $CAT; 
}


##
# Get a beautiful string with attribute name and require state.
#
# @return
#   scalar string
##

sub ToString(){
    my ($self)=@_;
    return "Attribute: ".$self->{TypeName}." #".$self->{RequireOrExclude}; 
}

1;