package SDB::Install::MonitoredTraceFile;

use base SDB::Install::MonitoredTraceDirectory;
use File::Basename qw (dirname basename);
use SDB::Install::SysVars qw ($isWin);
use strict;

sub new{
    my $self = shift->SUPER::new ();
    (
        $self->{'fullFileName'},       # mandatory
        $self->{'fullArchiveName'}    # mandatory
    ) = @_;
    if($isWin) {
        $self->{'fullFileName'}     =~ s/\//\\/g;
        $self->{'fullArchiveName'} =~ s/\//\\/g;
    }
    $self->{'fullDirName'} = dirname ($self->{'fullFileName'});
    $self->{'baseFileName'} = basename ($self->{'fullFileName'});
    return $self;
}


sub takeSnapshot {
    my (
        $self,
        $label, # optional; array $self->{'snapshots'} is ordered chronologically anyway
     ) = @_;
     my @statbuf;
     my $snapshot = {};
     push(@{$self->{'snapshots'}}, $snapshot);
     my $path;
     my $dir;
     $snapshot->{'label'} = $label;
     $snapshot->{'filedescs'} = {};
     if (! -f $self->{fullFileName}){
        return 1;
    }
     @statbuf = stat(_);
     my $filedesc = {
         'size'    => $statbuf[7],
         'mtime'   => $statbuf[9],
         #'md5sum'  => MD5Sum($path)
     };
     $snapshot->{'filedescs'}->{$self->{baseFileName}} = $filedesc;
     return 1;
}

1;
