#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: base class providing MsgList support

package SDB::Install::MsgLst;
use Time::HiRes qw (gettimeofday);
use SDB::Install::Msg ();
use strict;

#require Exporter;
#our @ISA = qw (Exporter);

#our @EXPORT = qw (addSubMessage addSubMsgLst addError addMessage
#                   AddSubMessage AddSubMsgLst AddError AddMessage);

#----------------------------------------------------------------------------

sub new{
    return bless ({'msg_lst' => []}, shift);
}

#----------------------------------------------------------------------------

sub initMsgLst{
    $_[0]->{'msg_lst'} = [];
}

#----------------------------------------------------------------------------

sub initWithMsgLst {
    my ($self, $other) = @_;
    $self->{'msg_lst'} = [];
    $self->appendMsgLst($other);
}

#----------------------------------------------------------------------------

sub setProgressHandler{
    if (defined $_[1]){
        $_[0]->{progress_handler} = $_[1];
    }
    else{
        delete $_[0]->{progress_handler};
    }
}

#----------------------------------------------------------------------------

sub getProgressHandler{
    $_[0]->{progress_handler};
}


sub addMessage{
    my ($self,$text,$sublist,$type,$level) = @_;

    if (!defined $text){
        if (defined $sublist){
            $self->appendMsgLst ($sublist);
            initMsgLst ($sublist);
        }
        return undef;
    }

    my $msg = new SDB::Install::Msg ($type, $text, defined $level ? $level : 1,
        ref ($self) =~ /::/ ? $self : undef);
	if (defined $self->{progress_handler}){
		$msg->setProgressHandler ($self->{progress_handler});
	}
    if (defined $sublist && $sublist != $self){
        $msg->getSubMsgLst->setMsgLst ($sublist);
        initMsgLst ($sublist);
    }
    push @{$self->{msg_lst}}, $msg;
    return $msg;
}

sub appendMsg{
    my ($self,$msg) = @_;
    push @{$self->{msg_lst}}, $msg;
    return $msg;
}

sub getMessages {
    my ($self) = @_;
    return defined($self->{msg_lst}) ? [ @{$self->{msg_lst}} ] : [];
}

#----------------------------------------------------------------------------

sub addMessages{
    my ($self,$textList,$type,$level) = @_;
    if (!defined $level){
        $level = 2;
    }
    foreach my $line (@$textList) {
        addMessage($self, $line, undef, $type, defined $level ? $level : 2);
    }
}

#----------------------------------------------------------------------------

sub appendMsgLst{
    if (!defined $_[1] || !defined $_[1]->{msg_lst}){
        return 1;
    }
    push @{$_[0]->{msg_lst}}, @{$_[1]->{msg_lst}};
    #$_[1]->{msg_lst} = [];
}

#----------------------------------------------------------------------------

sub setMsgLst{
    if (!defined $_[1] || !defined $_[1]->{msg_lst}){
        $_[0]->{msg_lst} = [];
    }
    $_[0]->{msg_lst} = $_[1]->{msg_lst};
    #$_[1]->{msg_lst} = [];
}

#----------------------------------------------------------------------------

sub addProgressMessage{
    my ($self,$text,$list,$level,$setOutputHandlerKey) = @_;
    if (exists $self->{progress_handler}){
        my $outputHandlerKey = '';
        if (defined $setOutputHandlerKey && $setOutputHandlerKey){
            $outputHandlerKey = '>';
        }
        $self->{progress_handler}->SetProgress ($outputHandlerKey . $text);
    }
    if (!defined $level){
        $level = 2;
    }
    my $msg = addMessage ($self,$text,$list,undef,$level);
    return $msg;
}

#----------------------------------------------------------------------------

sub addError{
    my ($self,$text,$list,$level) = @_;
    if (!defined $level){
        $level = 2;
    }
    my $msg = addMessage ($self, $text,undef,'ERR',$level);

    if (defined $list){
        if (!defined $text){
            $self->appendMsgLst ($list);
        }
        else{
            $msg->getSubMsgLst ()->setMsgLst ($list);
        }
    }
    return $msg;
}

#----------------------------------------------------------------------------

sub addWarning{
    my ($self,$text,$list, $level) = @_;
    if (!defined $level){
        $level = 2;
    }
    addMessage ($self, $text, $list, 'WRN', $level);
}


#----------------------------------------------------------------------------

sub isEmpty{
    @{$_[0]->{msg_lst}} ? 0 : 1; 
}

#----------------------------------------------------------------------------

sub getMsgLstString{
    my ($self, $indent,$withTimestamp,$withType) = @_;
    my $result = '';
    if (! defined $indent){
        $indent = '';
    }
    else{
        $indent .= '  ';
    }
    foreach my $msg (@{$self->{msg_lst}}){
        if (!defined $msg){
            next;
        }
        $result .= ${$msg->getMsgString ($indent, $withTimestamp, $withType)};
    }
    return \$result;
}

#----------------------------------------------------------------------------
sub getMsgLstXML{
    my ($self) = @_;
    my ($t,$msec) = gettimeofday ();
    $msec /= 1000;
    my $formated_time;
    SDB::Install::Msg::getDateTimeStamp (\$formated_time, $t,$msec);
    my $buf = '<MSGL _NO="1" _PROCESS="'.$$.'" _THREAD="0" _TIME="'.$formated_time.'">'."\n";
    foreach my $msg (@{$self->{msg_lst}}){
        if (!defined $msg){
            next;
        }
        $buf .= ${$msg->getMsgXML ('  ')};
    }
    $buf .= '</MSGL>'."\n";
    return \$buf;
}

#----------------------------------------------------------------------------

sub getMsgLstXMLString{
    my ($self,$indent) = @_;

    if (!defined $indent){
        $indent = '';
    }
    my $buf = '';
    if (!$self->isEmpty ()){
        $buf .=  $indent . '<MSGC>' . "\n";
        foreach my $msg (@{$self->{msg_lst}}){
            if (!defined $msg){
                next;
            }
            $buf .= ${$msg->getMsgXML ("$indent  ")};
        }
        $buf .=  $indent . '</MSGC>' . "\n";
    }
    return \$buf;
}

#----------------------------------------------------------------------------

sub injectIntoConfigHash{
    my ($self, $cfg) = @_;
    if (ref ($cfg) ne 'HASH'){
        croak ("injectConfigHash () requires a hash reference");
    }
    $cfg->{msg_lst} = $self->{msg_lst};
    return 1;
}


#----------------------------------------------------------------------------

################################### TO BE DELETED ###########################

#
# deprecated functions
#

sub getMsgLstObjFromParam ($$){
    if (!defined $_[0] || !ref ($_[0])){
        return undef;
    }
    if (ref ($_[0]) eq 'HASH'){
        return bless ($_[0], 'SDB::Install::MsgLst');
    }
    if ($_[0]->isa ('SDB::Install::MsgLst')){
        return $_[0];
    }
    elsif ($_[0]->isa ('SDB::Install::Base')){
        if ($_[1]){
            return $_[0]->getErrMsgLst();
        }
        else{
            return $_[0]->getMsgLst();
        }
    }
    return undef;
}

sub SetFormatInfo {$_[1]->endMessage(1, $_[3])};

sub GetErrorString;
*GetErrorString = \&getErrorString;

sub GetMsgListString;
*GetMsgListString = \&getMsgLstString;

sub LogMessages{
    my ($self) = @_;
    return unless defined $self->{log};
    appendMsgLst ($self->{log}, $self);
}

sub AddSubMessage{
    my ($self,$msg,$submsg,$sublist,$type,$level) = @_;
    $sublist = getMsgLstObjFromParam ($sublist,0);
    if (defined $sublist && !defined $sublist->{msg_lst} && defined $sublist->{msglst}){
        $sublist = $sublist->{msglst};
    }
    return $msg->getSubMsgLst()->addMessage ($submsg,$sublist,$type,defined $level ? $level : 2)
}

sub AddSubMsgLst{
    my ($self,$msg,$sublist) = @_;
    $sublist = getMsgLstObjFromParam ($sublist,0);
    if (defined $sublist && !defined $sublist->{msg_lst} && defined $sublist->{msglst}){
        $sublist = $sublist->{msglst};
    }
    return $msg->getSubMsgLst()->appendMsgLst ($sublist);
}

sub AddError{
    my ($self, @args) = @_;
    $args[1] = getMsgLstObjFromParam ($args[1],1);
    if (ref ($self) eq 'HASH'){
        $self = bless ($self, __PACKAGE__);
    }
    $self->addError (@args);
}

sub PushError{
    my ($self, @args) = @_;
    $args[1] = getMsgLstObjFromParam ($args[1],1);
    if (ref ($self) eq 'HASH'){
        $self = bless ($self, __PACKAGE__);
    }
    $self->addError (@args);
}

sub AddWarning{
    my ($self, $text, $sublst, $level) = @_;
    $sublst = getMsgLstObjFromParam ($sublst,0);
    my $msglst = getMsgLstObjFromParam ($self,0);
    return $msglst->addWarning ($text, $sublst, 2);

}

sub AddMessage{
    my ($self, @args) = @_;
    $args[1] = getMsgLstObjFromParam ($args[1],0);
    if (ref ($self) eq 'HASH'){
        $self = bless ($self, __PACKAGE__);
    }
    $self->addMessage (@args);
}

sub AddMessages{
    my ($self,$textList,$type,$level) = @_;
    foreach my $line (@$textList) {
        AddMessage ($self, $line, undef, $type, 3);
    }
}

sub SetProgressHandler;
*SetProgressHandler = \&setProgressHandler;

sub GetProgressHandler;
*GetProgressHandler = \&getProgressHandler;

1;
