package SDB::Install::OutputHandler;

use strict;

our $defaultPattern = 'ing\s|started|stopped|\.\.\.$';

sub new{
    my $self = bless ({}, shift);
    ($self->{_progressHandler}, $self->{_indention}) = @_;
    return $self;
}

sub setProgressHandler{
    $_[0]->{_progressHandler} = $_[1];
}

sub setIndention{
    $_[0]->{_indention} = $_[1];
}

sub getPatternList{
    return undef;
}

sub match{
    my $patternList = $_[0]->getPatternList();
    if (defined $patternList){
        foreach my $pattern (@$patternList){
            if ($_[1] =~ /$pattern/){
                return 1;
            }
        }
        return 0;
    }
    return $_[1] =~ /$defaultPattern/i;
}


sub addLine{
    if (!defined $_[0]->{_progressHandler}){
        return undef;
    }
    if ($_[0]->match ($_[1])){
        $_[0]->{_progressHandler}->SetProgress (
                    defined $_[0]->{_indention} ?
                    $_[0]->{_indention} . $_[1] :
                    $_[1]);
    }
}

1;

