package SDB::Install::PasswordPolicy;

use strict;

use base qw (SDB::Install::Base Exporter);

sub new {
    my ($class, $pattern, $minLength) = @_;

    my $self = $class->SUPER::new ();
    $self->{pattern} = $pattern // 'Aa1';
    $self->{minLength} = $minLength // 8;

    $self->{numberOfUpperCase} = $self->{pattern} =~ tr/A-Z//;
    $self->{numberOfLowerCase} = $self->{pattern} =~ tr/a-z//;
    $self->{numberOfDigits} = $self->{pattern} =~ tr/0-9//;
    $self->{numberOfSpecial} = length($self->{pattern}) - $self->{numberOfUpperCase} - $self->{numberOfLowerCase} - $self->{numberOfDigits};

    return $self;
}

sub isCompliant {
    my ($self, $password) = @_;

    return 0 if length($password) < $self->{minLength};

    my $numberOfUpperCase = $password =~ tr/A-Z//;
    return 0 if $numberOfUpperCase < $self->{numberOfUpperCase};

    my $numberOfLowerCase = $password =~ tr/a-z//;
    return 0 if $numberOfLowerCase < $self->{numberOfLowerCase};

    my $numberOfDigits = $password =~ tr/0-9//;
    return 0 if $numberOfDigits < $self->{numberOfDigits};

    my $numberOfSpecial = length($password) - $numberOfUpperCase - $numberOfLowerCase - $numberOfDigits;
    return 0 if  $numberOfSpecial < $self->{numberOfSpecial};

    return 1;
}

sub getMessage {
    my ($self) = @_;

    my $msg = "Password should consists of at least ".$self->{minLength}." characters and should contain at least";
    my $subMsg;
    if ($self->{numberOfUpperCase}==1) {
        $subMsg = " 1 upper case letter";
    } elsif ($self->{numberOfUpperCase}>1) {
        $subMsg = " ".$self->{numberOfUpperCase}." upper case letters";
    }
    if ($self->{numberOfUpperCase}>0) {
        $msg.=$subMsg;
        $msg = $self->_addDelimeter($msg, $self->_numberOfCategoriesLeft($self->{numberOfLowerCase}, $self->{numberOfDigits}, $self->{numberOfSpecial}));
    }

    if ($self->{numberOfLowerCase}==1) {
        $subMsg = " 1 lower case letter";
    } elsif ($self->{numberOfLowerCase}>1) {
        $subMsg = " ".$self->{numberOfLowerCase}." lower case letters";
    }
    if ($self->{numberOfLowerCase}>0) {
        $msg.=$subMsg;
        $msg = $self->_addDelimeter($msg, $self->_numberOfCategoriesLeft($self->{numberOfDigits}, $self->{numberOfSpecial}));
    }

    if ($self->{numberOfDigits}==1) {
        $subMsg = " 1 digit";
    } elsif ($self->{numberOfDigits}>1) {
        $subMsg = " ".$self->{numberOfDigits}." digits";
    }
    if ($self->{numberOfDigits}>0) {
        $msg.=$subMsg;
        $msg = $self->_addDelimeter($msg, $self->_numberOfCategoriesLeft($self->{numberOfSpecial}));
    }

    if ($self->{numberOfSpecial}==1) {
        $subMsg = " 1 special character";
    } elsif ($self->{numberOfSpecial}>1) {
        $subMsg = " ".$self->{numberOfSpecial}." special characters";
    }
    if ($self->{numberOfSpecial}>0) {
        $msg.=$subMsg;
        $msg = $self->_addDelimeter($msg, 0);
    }

    return $msg;
}

sub _addDelimeter {
    my ($self, $msg, $numberOfCategoriesLeft) = @_;
    if ($numberOfCategoriesLeft==0) {
       return "$msg.";
    } elsif ($numberOfCategoriesLeft==1) {
       return "$msg and";
    } else {
       return "$msg,";
    }
}

sub _numberOfCategoriesLeft {
    my ($self, $cat1, $cat2, $cat3) = @_;
    my $result = 0;
    $result++ if (defined $cat1 and $cat1>0);
    $result++ if (defined $cat2 and $cat2>0);
    $result++ if (defined $cat3 and $cat3>0);
    return $result;
}

1;
