package SDB::Install::Persistence::Schema;

use strict;

my $PERSISTENCE_XML_XSD = << 'END';
<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://www.w3.org/2001/XMLSchema" targetNamespace="http://www.hdblcm.org/persistence" xmlns:tns="http://www.hdblcm.org/persistence" version="1.1">

	<element name="persistence" type="tns:persistence"></element>

	<complexType name="persistence">
		<all>
			<element name="source_version" type="tns:version" maxOccurs="1" minOccurs="0">
			</element>
			<element name="target_version" type="tns:version" maxOccurs="1" minOccurs="1">
			</element>
			<element name="date" type="dateTime" maxOccurs="1" minOccurs="1">
			</element>
			<element name="next_phase" type="tns:phaseType" maxOccurs="1" minOccurs="0">
			</element>
			<element name="component_name" type="tns:mandatoryString" maxOccurs="1" minOccurs="1">
			</element>
			<element name="step" type="string" maxOccurs="1" minOccurs="0">
			</element>
			<element name="action" type="tns:actionType" maxOccurs="1" minOccurs="1">
			</element>
			<element name="extensions" type="tns:extensionsType" maxOccurs="1" minOccurs="0"></element>
		</all>
		<attribute name="version" type="tns:version"></attribute>
	</complexType>

	<simpleType name="actionType">
		<restriction base="string">
			<enumeration value="install"></enumeration>
			<enumeration value="update"></enumeration>
		</restriction>
	</simpleType>

	<simpleType name="version">
		<restriction base="string">
			<pattern value="\d+(\.\d+)*"></pattern>
		</restriction>
	</simpleType>


	<complexType name="extensionsType">
		<sequence>
			<any minOccurs="0" maxOccurs="unbounded" processContents="lax"></any>
		</sequence>
	</complexType>

    <simpleType name="mandatoryString">
    	<restriction base="string">
    		<minLength value="1"></minLength>
    	</restriction>
    </simpleType>

    <simpleType name="phaseType">
    	<restriction base="string">
    		<enumeration value="prepare"></enumeration>
    		<enumeration value="offline"></enumeration>
    		<enumeration value="online"></enumeration>
            <enumeration value="system_online"></enumeration>
    	</restriction>
    </simpleType>
</schema>
END

sub validate {
	my ($xmlTree) = @_;
	require XML::LibXML;
	XML::LibXML::Schema->new(string => $PERSISTENCE_XML_XSD)->validate($xmlTree);
}

1;