package SDB::Install::SAPSystemContainerHelper::ActivatePluginsContainerHelper;

use strict;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::IOHelper;
use SDB::Install::SysInfo;
use SDB::Install::OSConfig;
use SDB::Install::SAPInstance::TrexInstance;
use SDB::Install::SAPSystem;

our @ISA = qw (SDB::Install::Base SDB::Install::SAPSystemUtilities);


sub activatePlugins{
    my (
        $self,
        $instconfig,
        $sapSys
    ) = @_;
    my $msglst = $self->getMsgLst();
    my $msg = $msglst->addProgressMessage("Activating plugins");
    $msg->setEndTag('Done.');
    $sapSys->setMsgLstContext ([$msg->getSubMsgLst()]);
    my $rc = $sapSys->activateNewVersion($instconfig->getValue('CustomPluginsPath'));
    if(!$rc) {
        $self->setErrorMessage ("Plugin activation failed", $sapSys->getErrMsgLst());
        return undef;
    }
    return 1;
}

1;
