package SDB::Install::SAPSystemContainerHelper::CheckSystemRequirementsContainerHelper;

use strict;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::IOHelper;
use SDB::Install::SysInfo;
use SDB::Install::ContainerOSConfig;
use SDB::Install::SAPInstance::TrexInstance;
use SDB::Install::SAPSystem;

our @ISA = qw (SDB::Install::Base SDB::Install::SAPSystemUtilities);


#-------------------------------------------------------------------------------
# checks the minimum system requirements in a docker container
# This method is called from SDB::Install::App::Console::HdbContainer
#
# Parameters: $instconfig  SDB::Install::Configuration::ContainerHelper
#             $sapSys      SDB::Install::SAPSystem
#
# Returns int retCode


sub checkSystemRequirements {
    my ($self, $instconfig, $sapSys) = @_;
    my $instance = $sapSys->getNewDBInstances()->[0];
    my $msglst   = $self->getMsgLst();

    my $msg = $msglst->addProgressMessage("Checking system requirements...");
    $instconfig->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $instconfig->checkSystemRequirements(new SDB::Install::SysInfo(), $sapSys->getManifest())){
        $self->setErrorMessage ("Checking the minimum system requirements failed", $instconfig->getErrMsgLst());
        return undef;
    }
    my $osconfig = new SDB::Install::ContainerOSConfig ();
    $msg = $msglst->addProgressMessage("Checking linux settings...");
    $osconfig->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!$osconfig->checkSystemConfig($sapSys->getUser()->getSidAdmName(),
                                      $instconfig->getValue('RAM'),
                                      $instconfig->getValue('FailOn')) ) {
        $self->setErrorMessage ("Check linux settings failed", $osconfig->getErrMsgLst);
        return undef;
    }
    return 1;
}

1;
