package SDB::Install::System::IPAddr;
use Net::IP qw (ip_get_mask ip_bintoip ip_inttobin ip_bintoint $IP_IDENTICAL);
our @ISA = ('Net::IP','SDB::Install::Base');
use strict;


sub new{
    my ($ip,$prefix_len) = split ('/',$_[1]);
    if (!$ip){
        $ip = $_[1];
    }
    my $self = shift->SUPER::new ($ip);
    if (!defined $self){
        return undef;
    }
    $self->{prefixLen} = $prefix_len;
    return $self;
}

sub getPrefix{
    my ($self,$prefix_len) = @_;

    if (!defined $prefix_len){
        $prefix_len = $self->{prefixLen};
    }

    my $intMask = ip_bintoint(ip_get_mask ($prefix_len,$self->version));
    my $prefix_int = $intMask & $self->intip ();
    my $prefix = new Net::IP (ip_bintoip(ip_inttobin($prefix_int,$self->version),$self->version) . '/'. $prefix_len);
    if (!defined $prefix){
        $self->setErrorMessage ("Cannot get prefix of ip '".$self->print()."': " . Net::IP::Error());
        return undef;
    }
    return bless ($prefix,__PACKAGE__);
}

sub print{
    my ($self) = @_;
    if (defined $self->{prefixLen}){
        return $self->short . '/' . $self->{prefixLen};
    }
    return $self->SUPER::print();
}

sub belongsToSubnet{
    my ($self,$subnetPrefix) = @_;
    my $rc = 0;
    my $msglst = $self->getMsgLst ();
    my $ownPrefix = $self->getPrefix ();
    if (!defined $ownPrefix){
        $self->setErrorMessage ("Cannot get prefix of local ip address '".$self->print()."': " . Net::IP::Error());
        return undef
    }
    my $overlaps = $subnetPrefix->overlaps ($ownPrefix);
    if (defined $overlaps && ($overlaps == $IP_IDENTICAL)){
        $msglst->addMessage ("Local ip '".$self->print()."' belongs to subnet ". $subnetPrefix->print ());
        return 1;
    }
    $msglst->addMessage ("Local ip address '".$self->print()."' doesn't belong to subnet ". $subnetPrefix->print ());
    return 0;
}

sub findSubnetDeviceIps{
    my ($self, $ipList) = @_;
    if (!defined $ipList){
        return [];
    }
    my @result;
    foreach my $ip (@$ipList){
        if ($ip->belongsToSubnet ($self)){
            push @result, $ip;
        }
    }
    return \@result;
}

1;
