package SDB::Install::System::Registration::ODBC;

#
# module to handle odbc driver registrations
#

use SAPDB::Install::System::Win32::Registry;
use SAPDB::Install::System::Win32::API;
use SDB::Install::BaseLegacy;
use SDB::Install::SysVars;
use SDB::Install::System qw(isSameFile2 getFileId);
use strict;

our @ISA = qw (SDB::Install::BaseLegacy);

our %drivers = ();

our $hkey_root = HKEY_LOCAL_MACHINE;
our $hkey_root_name = 'HKEY_LOCAL_MACHINE';
our $key_name_odbcinst_ini = 'SOFTWARE\ODBC\ODBCINST.INI';
our $subkey_name_drivers = 'ODBC Drivers';

sub readDrivers{
    my ($self, $nocache) = @_;
    if (scalar (keys (%drivers)) && !$nocache){
        return \%drivers;
    }
    $self->reset();
    my $keyname_drivers = $key_name_odbcinst_ini . '\\' . $subkey_name_drivers;
    my $hKey;
    if (RegOpenKeyEx ($hkey_root,$keyname_drivers, 0, KEY_READ, $hKey ) != 0){
        $self->AddError ("Cannot open registry key '$hkey_root_name\$keyname_drivers': $!");
        return undef;
    }
    my ($valCount, $index, $sValName, $piType, $pValData);
    RegQueryInfoKey ($hKey, 0, 0, 0, 0, 0, 0, $valCount, 0, 0, 0, 0);
    my @names;
    for ($index = 0; $index < $valCount; $index++){
        RegEnumValue( $hKey, $index ,$sValName, 0, 0, $piType, $pValData, 0 );
        if(Win32::GetLastError()==259){last;}
        if ($pValData eq 'Installed'){
            push  @names, $sValName;
        }
    }

    my ($keyName);

    foreach my $name (@names){
        $keyName = $key_name_odbcinst_ini . '\\' . $name;
        if (RegOpenKeyEx ($hkey_root,$keyName, 0, KEY_READ, $hKey ) != 0){
            $self->AddWarning ("Cannot open registry key '$hkey_root_name\$keyName': $!");
            next;
        }
        $drivers{$name} = {};
        RegQueryInfoKey ($hKey, 0, 0, 0, 0, 0, 0, $valCount, 0, 0, 0, 0);
        for ($index = 0; $index < $valCount; $index++){
            RegEnumValue( $hKey, $index ,$sValName, 0, 0, $piType, $pValData, 0);
            if(Win32::GetLastError()==259){last;}
            if($piType == REG_BINARY){
                $pValData=unpack("H*",$pValData);
            }
            elsif($piType == REG_EXPAND_SZ){
                ExpandEnvironmentStrings($pValData,$pValData,0);
            }
            $sValName = '(Default)' unless $sValName =~ /\S/;
            $drivers{$name}->{$sValName}=$pValData;
        }
        if (!RegCloseKey( $hKey ) == 0){
            $self->AddWarning ("Can't close registry key '$hkey_root_name\$keyName': $!");
        }
    }
    return \%drivers;
}

sub new {
    my $self = shift->SUPER::new ();
    my ($name) = @_;
    if (defined $name){
        $self->init ($name);
    }
    return $self;
}

sub init{
    my ($self,$name) = @_;
    my $rDrivers = $self->readDrivers ();
    if (!defined $rDrivers ||  !exists $rDrivers->{$name}){
        $self->AddError ("ODBC driver name '$name' not found");
        return undef;
    }
    $self->{name} = $name;
    $self->{regData} = $rDrivers->{$name};
    return 1;
}

sub getDriverNames{
    my ($self, $nocache) = @_;
    $self->readDrivers ($nocache);
    return [keys %drivers];
}

sub getModule{
    return $_[0]->{regData}->{Driver};
}

sub assignedToInstallation{
    my ($self, $installation,$fileId) = @_;
    my $module = $self->getModule ();
    my ($basePathModule) = ($module =~ /^(.*)[\\\/][^\\\/]+$/);
    my $instpath;
    if (!defined $fileId){
        $instpath = $installation->getProgramPath ();
    }
    if (isSameFile2 ($basePathModule, $instpath, $fileId)){
        return 1;
    }
    return 0;
}

sub getDriverNamesAssignedToInstallation{
    my ($self, $installation, $nocache) = @_;
    my $names = $self->getDriverNames ($nocache);
    if (!defined $names){
        return undef;
    }
    if (!@$names){
        return ();
    }

    my $instpath = $installation->getProgramPath ();
    my $fileId = getFileId (\$instpath);
    if (! scalar @$fileId){
        $self->AddError ("Cannot find directory '$instpath'");
        return undef;
    }
    my @result;
    my $tmpDriver = new SDB::Install::System::Registration::ODBC ();
    foreach my $name (@$names){
        if (!defined $tmpDriver->init ($name)){
            next;
        }
        if ($tmpDriver->assignedToInstallation (undef, $fileId)){
            push  @result, $name;
        }
    }
    return \@result;
}


sub reset{
    %drivers = ();
}

1;
