package SDB::Install::Utils::DatabaseStudio::DatabaseStudioKnownFeatures;

use Exporter;

our @ISA = qw (Exporter);
our @EXPORT = qw(IsKnownFeatureKey IsKnownFeatureId GetKnownFeatureIdByKey GetDescription GetBatchKey GenerateFeatureDescriptionText ANSWERS_LEGAL_NOTE FEATURE_ID_ANSWERS);

sub FEATURE_ID_ADMIN  {'com.sap.ndb.studio.admin.feature.feature.group'}
sub FEATURE_ID_APPDEV {'com.sap.ndb.studio.appdev.feature.feature.group'}
sub FEATURE_ID_DBDEV  {'com.sap.ndb.studio.dbdev.feature.feature.group'}
sub FEATURE_ID_ANSWERS  {'com.sap.ndb.studio.answers.feature.feature.group'}
sub FEATURE_ID_IMPORT_METADATA  {'com.sap.ndb.studio.importmetadata.feature.feature.group'}
sub FEATURE_ID_STREAMING {'com.sybase.esp.studio.feature.feature.group'}
sub FEATURE_ID_MODELING_FRAMEWORK {'com.sap.ndb.studio.mfw.feature.feature.group'}
sub FEATURE_ID_MODELER_COMPARE {'com.sap.ndb.studio.modelcompare.feature.feature.group'}

sub ANSWERS_LEGAL_NOTE {'The SAP HANA ANSWERS feature is SUBJECT TO TERMS OF USE AGREEMENT AND PRIVACY STATEMENT FOR SAP HANA ANSWERS SET FORTH AT HTTP://ANSWERS.SAPHANA.COM'}

our $knownFeatures = {
	FEATURE_ID_ADMIN () => {
		'batchKey' => 'admin',
		'desc'     => 'SAP HANA Studio Administration'
	},
	FEATURE_ID_APPDEV () => {
		'batchKey' => 'appdev',
		'desc'     => 'SAP HANA Studio Application Development'
	},
	FEATURE_ID_DBDEV () => {
		'batchKey' => 'dbdev',
		'desc'     => 'SAP HANA Studio Database Development'
	},
    FEATURE_ID_ANSWERS () => {
        'batchKey' => 'answers',
        'desc'     => 'SAP HANA Answers'
    },	
    FEATURE_ID_IMPORT_METADATA () => {
        'batchKey' => 'importmetadata',
        'desc'     => 'SAP HANA Modeler - Import Metadata'
    },
    FEATURE_ID_STREAMING () => {
    	'batchKey' => 'streaming',
        'desc'     => 'SAP HANA Streaming Analytics',# Must be modified when description of feature is changed
    },
    FEATURE_ID_MODELING_FRAMEWORK () => {
    	'batchKey' => 'mfw',
        'desc'     => 'SAP HANA Studio - Modeling Framework',
    },
    FEATURE_ID_MODELER_COMPARE () => {
    	'batchKey' => 'modelcompare',
        'desc'     => 'SAP HANA Modeler - Model Compare',
    }
};

sub GetKnownFeatureIdByKey {
	my ( $key ) = @_;
	if( ! defined $key ){
		return undef;
	}
	foreach my $feature ( keys %$knownFeatures ) {
		my $currentKey = $knownFeatures->{$feature}->{'batchKey'};
		if ( $currentKey eq $key ) {
			return $feature;
		}
	}
	return undef;
}

sub IsKnownFeatureKey {
	my ( $key ) = @_;
	return defined GetKnownFeatureIdByKey ( $key );
}

sub IsKnownFeatureId {
	my ( $id ) = @_;
	return defined $knownFeatures->{$id};
}

sub GetDescription {
	my ( $feature ) = @_;

	my $retrievedFeatureDescription = $feature->{desc};

	if ( defined $retrievedFeatureDescription ) {
		return $retrievedFeatureDescription;
	}
	my $id = $feature->{id};
	if ( IsKnownFeatureId($id) ) {
		return $knownFeatures->{$id}->{'desc'};
	}
	return undef;
}

sub GetBatchKey {
	my ( $id ) = @_;
	return $knownFeatures->{$id}->{'batchKey'};
}

sub GenerateFeatureDescriptionText {
	my ( $feature, $isWholeVersionStr ) = @_;
	my $desc = _GetFeatureText ($feature);
	my $version = $feature->{version};
	return $desc . ($isWholeVersionStr ? " version " : " ver. ") . $version;
}

sub _GetFeatureText {
	my ( $feature ) = @_;
	
	my $featureDescription = GetDescription ( $feature );
	if ( defined $featureDescription ) {
		return $featureDescription;
	}
	return $feature->{id};
}

1;
