package SDB::Install::Version;

use base SDB::Install::BaseLegacy;
use strict;

sub new {
	my $self = shift->SUPER::new ();
	if (@_) {
		my $maxDefinedIndex;
		my @intVersion;
		my @stringVersion;
		foreach my $i (0..scalar @_ -1) {
			if (defined $_[$i]) {
				$maxDefinedIndex = $i;
			}
		}
		foreach my $i (0..$maxDefinedIndex) {
			if (!defined $_[$i]) {
				next;
			}
			my $digits = $_[$i];
			if (defined $digits){
				if ($digits =~ /^\d+$/){
					push(@intVersion,    int($digits));
					push(@stringVersion, "$digits"); # Force string context here
				}
				else{
					push(@intVersion,    undef);
					push(@stringVersion, $digits);
				}
			}
		}
		$self->{intVersionDetails} = \@intVersion;
		$self->{stringVersionDetails} = \@stringVersion;
	}
	
	return $self;
}

sub _getIntegerDetails {
	return $_[0]->{intVersionDetails};
}

sub _getStringDetails {
	return $_[0]->{stringVersionDetails};
}

sub isEqual {
	my ($self, $otherVersion) = @_;
	my $integerDetails = $self->{intVersionDetails};
	my $stringDetails = $self->{stringVersionDetails};
	my $otherIntegerDetails = $otherVersion->{intVersionDetails};
	my $otherStringDetails = $otherVersion->{stringVersionDetails};

	if (!defined $integerDetails || !defined $otherIntegerDetails) {
		return 0;
	}

	my $minLength = scalar @$integerDetails;
	if ($minLength < scalar @$otherIntegerDetails) {
		$minLength = scalar @$otherIntegerDetails;
	}

	foreach my $i (0..($minLength - 1)) {
		if (($stringDetails->[$i] =~ /\D/) || ($otherStringDetails->[$i] =~ /\D/)){
			if ($stringDetails->[$i] ne $otherStringDetails->[$i]){
				return 0;
			}
			next;
		}
		if ($integerDetails->[$i] != $otherIntegerDetails->[$i]) {
			return 0;
		}
	}
	return 1;
}

sub isNewerThan {
	# returns 1 if this version is newer than $otherVersion, 0 otherwise
	# parameters:  SDB::Install::Version $otherversion
	my ($self, $otherVersion) = @_;
	my $integerDetails = $self->{intVersionDetails};
	my $stringDetails = $self->{stringVersionDetails};
	my $otherIntegerDetails = $otherVersion->{intVersionDetails};
	my $otherStringDetails = $otherVersion->{stringVersionDetails};

	if (!defined $integerDetails || !defined $otherIntegerDetails) {
		return 0;
	}
	my $minLength = scalar @$integerDetails;
	if ($minLength < scalar @$otherIntegerDetails) {
		$minLength = scalar @$otherIntegerDetails;
	}
	foreach my $i (0..($minLength -1)) {
		if (($stringDetails->[$i] =~ /\D/) || ($otherStringDetails->[$i] =~ /\D/)){
			if ($stringDetails->[$i] gt $otherStringDetails->[$i]){
				return 1;
			}
			if ($stringDetails->[$i] lt $otherStringDetails->[$i]){
				return 0;
			}
			next;
		}
		if ($integerDetails->[$i] > $otherIntegerDetails->[$i]) {
			return 1;
		} 
		if ($integerDetails->[$i] < $otherIntegerDetails->[$i]) {
			return 0;
		} 
	}

	if ($self->isEqual($otherVersion)) {
		return 0;
	}

	return scalar @$integerDetails > scalar @$otherIntegerDetails;
}

sub asString {
	my ($self) = @_;
	if (!defined $self->_getStringDetails()) {
		return 'undefined';
	}
	return join('.', @{$self->_getStringDetails()});
}

1;
