package SDB::Web::TRACE;

use strict;
use base 'Exporter';

use Data::Dumper;

use Exporter 'import';

our @EXPORT_OK = qw( TRACE_VAR_TO_FILE );
our %EXPORT_TAGS = ( all => \@EXPORT_OK );

use constant {
    SLPP_TRACE_ENABLE => "SLPP_TRACE_ENABLE",
    SLPP_TRACE_ROOT => "SLPP_TRACE_ROOT"
};

sub TRACE_VAR_TO_FILE {
	my $method_name = shift();
	my $context_tag = shift();
	my $trace_tag = shift();
	my $var = shift();
	
	unless ( -e SLPP_TRACE_ROOT ) {
		return;
	}

	my $trace_root = undef;
	{
	  local $/ = undef;
	  open FILE, SLPP_TRACE_ROOT;
	  binmode FILE;
	  $trace_root = <FILE>;
	  close FILE;
	}

	unless( $trace_root ) {
		$trace_root = 'slpp_trace';
	}
	
	mkdir $trace_root;
	
	if ( defined $context_tag && $context_tag ne '' ) {
		$trace_root .= '/' . $context_tag . '_' . $method_name;
		mkdir $trace_root;
	}
	
	my $trace_file = $trace_tag;
	unless ( $trace_file ) {
		$trace_file = 'trace';
	}
	
    my $var_string = Data::Dumper->Dump([$var]);

	open(my $fh, '>', $trace_root . '/' . $trace_file );
	print $fh $var_string . "\n";
	close $fh;
}

1;