#############################################################################
## Name:        ext/pperl/splashfast/SplashFast.pm
## Purpose:     Wx::Perl::SplashFast -> Show a splash before loading Wx.
## Author:      Graciliano M. P.
## Modified by:
## Created:     30/06/2002
## Copyright:   (c) 2002-2003 Graciliano M. P.
## Licence:     This program is free software; you can redistribute it and/or
##              modify it under the same terms as Perl itself
#############################################################################

use strict;
use warnings;
use utf8;

package Wx::PNGHandler;
our @ISA = qw(Wx::ImageHandler);
1;

package Wx::MemoryDC;
our @ISA = qw(Wx::DC);
1;

package Wx::SplashScreen;
our @ISA = qw(Wx::Frame);
1;

package Wx::Frame;
our @ISA = qw(Wx::Window);
1;

package Wx::Window;
our @ISA = qw(Wx::EvtHandler);
1;

package SDB::Wx::Splash;

our $Window;
our $BuildString = '2.3.42 (git hash: d8ef2e72321b)';
eval {require SDB::Common::Archive::Tar};

sub new {
    my ($class, $archivename, $filename, $splash_time) = @_;

    Wx::loadMiniWx();
    new SDB::Wx::Splash::App();
    #Wx::InitAllImageHandlers() ;

    my $dummy;
    my $png = Wx::constant( 'wxBITMAP_TYPE_PNG', 0, $dummy );
    my $spl_c = Wx::constant( 'wxSPLASH_CENTRE_ON_SCREEN', 0, $dummy );
    my $spl_ti = Wx::constant( 'wxSPLASH_TIMEOUT', 0, $dummy );

    # load image from archive
    my $ah = new SDB::Common::Archive::Tar($archivename);
    my $fh = $ah->open ($filename);
    my $img = new Wx::Image();
    my $hnd = new Wx::PNGHandler();
    $hnd->LoadFile ($img, $fh);
    my $bitmap = new Wx::Bitmap($img);

    # draw version and copyright
    my $mdc = new Wx::MemoryDC();
    $mdc->SelectObject($bitmap);
    $mdc->SetTextForeground (new Wx::Colour (0x66, 0x66, 0x66));
    $mdc->SetFont (new Wx::Font (10,
        Wx::constant ('wxSWISS', 0, $dummy),
        Wx::constant ('wxNORMAL', 0, $dummy),
        Wx::constant ('wxBOLD', 0, $dummy)));
    #my $version_str = "Version $BuildString";
    #my ($version_w, $version_h) = $mdc->GetTextExtent ($version_str);
    #$mdc->DrawText($version_str, 25, 96);
    my $copyright_str = "\251 2000-2018 by SAP SE";
    my ($copyright_w, $copyright_h) = $mdc->GetTextExtent ($copyright_str);
    $mdc->DrawText($copyright_str, $bitmap->GetWidth() - $copyright_w - 20, $bitmap->GetHeight() - 20 - $copyright_h);
    $mdc->SelectObject(new Wx::Bitmap(0, 0, 0));

    $Window = new Wx::SplashScreen( $bitmap, $spl_c|$spl_ti, $splash_time, undef , -1 );
    my $evt_close = Wx::constant( 'wxEVT_CLOSE_WINDOW', 0, $dummy );
    $Window->Connect( -1, -1, $evt_close, sub {
                                             if( defined $Window ) {
                                                  $Window->Destroy();
                                                  $Window = undef;
                                               }
                                          });
    $img->Destroy();
    return $Window;
}

# the App for the splash screen
package SDB::Wx::Splash::App;
our @ISA = qw(Wx::_App) ;

sub OnInit {
    return 1;
}

package Wx;

our $VERSION = '0.9932';

sub wxPL_STATIC ();

sub _wx_boot($$) {
        if ($_[0] eq 'Wx' ) {
                require XSLoader;
                XSLoader::load( $_[0], $_[1] );
        } else {
                no strict 'refs';
                my $t = $_[0]; $t =~ tr/:/_/;
                &{"_boot_$t"}( $_[0], $_[1] );
        }
}

our $loaded = 0;

sub loadMiniWx{
    return if ($loaded);
    $loaded = 1;

    _wx_boot ('Wx', $VERSION);
    _boot_Constant ('Wx', $VERSION);
    _boot_GDI ('Wx', $VERSION);
    _boot_Events ('Wx', $VERSION);

     if( ( exists($ENV{WXPERL_OPTIONS}) && $ENV{WXPERL_OPTIONS} =~ /ENABLE_DEFAULT_ASSERT_HANDLER/) ) {
        Wx::EnableDefaultAssertHandler();
    } else {
        Wx::DisableAssertHandler();
    }

    unless (Load ()){
        die ("cannot open display\n");
    }
}

1;

