package SQLDBC;

use 5.014002;
use strict;
use warnings;

=head1 NAME

SQLDBC - A perl extension to use the HANA SQLDBC client

=cut

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use SQLDBC ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(

) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    SQLDBC_INVALID_OBJECT
    SQLDBC_OK
    SQLDBC_NOT_OK
    SQLDBC_DATA_TRUNC
    SQLDBC_OVERFLOW
    SQLDBC_SUCCESS_WITH_INFO
    SQLDBC_NO_DATA_FOUND
    SQLDBC_NEED_DATA
    SQLDBC_HOSTTYPE_MIN
    SQLDBC_HOSTTYPE_PARAMETER_NOTSET
    SQLDBC_HOSTTYPE_BINARY
    SQLDBC_HOSTTYPE_ASCII
    SQLDBC_HOSTTYPE_UTF8
    SQLDBC_HOSTTYPE_UINT1
    SQLDBC_HOSTTYPE_INT1
    SQLDBC_HOSTTYPE_UINT2
    SQLDBC_HOSTTYPE_INT2
    SQLDBC_HOSTTYPE_UINT4
    SQLDBC_HOSTTYPE_INT4
    SQLDBC_HOSTTYPE_UINT8
    SQLDBC_HOSTTYPE_INT8
    SQLDBC_HOSTTYPE_DOUBLE
    SQLDBC_HOSTTYPE_FLOAT
    SQLDBC_HOSTTYPE_ODBCDATE
    SQLDBC_HOSTTYPE_ODBCTIME
    SQLDBC_HOSTTYPE_ODBCTIMESTAMP
    SQLDBC_HOSTTYPE_ODBCNUMERIC
    SQLDBC_HOSTTYPE_GUID
    SQLDBC_HOSTTYPE_UCS2
    SQLDBC_HOSTTYPE_UCS2_SWAPPED
    SQLDBC_HOSTTYPE_UCS2_NATIVE
    SQLDBC_HOSTTYPE_BLOB
    SQLDBC_HOSTTYPE_ASCII_CLOB
    SQLDBC_HOSTTYPE_UTF8_CLOB
    SQLDBC_HOSTTYPE_UCS2_CLOB
    SQLDBC_HOSTTYPE_UCS2_SWAPPED_CLOB
    SQLDBC_HOSTTYPE_UCS2_NATIVE_CLOB
    SQLDBC_HOSTTYPE_STREAM
    SQLDBC_HOSTTYPE_RAWHEX
    SQLDBC_HOSTTYPE_DECIMAL
    SQLDBC_HOSTTYPE_OMS_PACKED_8_3
    SQLDBC_HOSTTYPE_OMS_PACKED_15_3
    SQLDBC_HOSTTYPE_OMS_TIMESTAMP
    SQLDBC_HOSTTYPE_OMS_ASCII
    SQLDBC_HOSTTYPE_DECFLOAT
    SQLDBC_HOSTTYPE_USERDEFINED
    SQLDBC_HOSTTYPE_MAX
    SQLDBC_StringEncodingUnknown
    SQLDBC_StringEncodingAscii
    SQLDBC_StringEncodingUTF8
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('SQLDBC', $VERSION);

# Preloaded methods go here.

1;
