from __future__ import print_function
import sys

if sys.version_info >= (3,):
    long = int

class ResultRow:
    """
    Result Row returned by fetch*()
    """
    def __init__(self, column_names=(), column_values=()):
        self.__update(column_names, column_values)

    def __repr__(self):
        return str(self.column_values)

    def __update(self, column_names, column_values):
        self.column_names = column_names
        self.column_values = column_values

    def __setitem__(self, key, value):
        if isinstance(key, (int, long)):
            self.column_values[key] = value
        elif type(key) == types.StringType:
            try:
                ind = self.column_names.index(key.upper())
                self.column_values[ind] = value
            except ValueError:
                raise KeyError("\'%s\' is not found" % key.upper())
        else:
            raise TypeError("%s is not supported as a key" % str(type(key)))

    def __getitem__(self, key):
        if isinstance(key, (int, long)):
            return self.column_values[key]
        elif isinstance(key, slice):
            return self.column_values[key.start:key.stop:key.step]
        elif isinstance(key, str):
            try:
                ind = self.column_names.index(key.upper())
                return self.column_values[ind]
            except ValueError:
                raise KeyError("\'%s\' is not found" % key.upper())
        else:
            raise TypeError("%s is not supported as a key" % str(type(key)))

    def __len__(self):
        return len(self.column_names)


    def __iter__(self):
        for value in self.column_values:
            yield value

    def __cmp__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        if self.column_values < other.column_values:
            return -1
        elif self.column_values == other.column_values:
            return 0
        else: # self > other
            return 1

    def __eq__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values == other.column_values

    def __ne__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values != other.column_values

    def __lt__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values < other.column_values

    def __le__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values <= other.column_values

    def __gt__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values > other.column_values

    def __ge__(self, other):
        if not isinstance(other, ResultRow):
            raise TypeError("%s is not a result row fetched by dbapi" % (other,))
        return self.column_values >= other.column_values

# self test
if __name__ == '__main__' :
    rr = ResultRow(('ELEM1', 'ELEm2', 'Elem3'), (1, 2))
    ss = ResultRow(('ELEM1', 'ELEm2', 'Elem3'), (1, 2))
    print(rr['ELem1'])
    print(rr[1])
    print(rr[0:-1])
    for col in rr:
        print(col)
    print(rr)
    print(ss)
    print(rr == ss)
