use SDB::Install::SysVars;
use SDB::Install::System qw (isAdmin exec_program);
use SDB::Install::System::EnvVariable;

use strict;

my $envvar = 'HDBDOTNETCORE';

sub Register {
    if (!$isWin) {
        return 1;
    }
    my ($self) = @_;
    my $path = $self->getPath () . $path_separator . "dotnetcore";
    my $var = new SDB::Install::System::EnvVariable ($envvar, $path);
    my $errlst = new SDB::Install::MsgLst ();
    my $msg = $self->AddMessage ("Setting " . $envvar . " environment variable to path: " . $path);
    $var->{EnvVarValue} = $path;
    $var->{EnvVarType} = 'USER';
    if (isAdmin ()) {
        $var->{EnvVarType} = 'SYSTEM';
    }
    if (!defined $var->set ()) {
        $self->AddError ("Failed to set " . $envvar, $errlst);
    }
    $self->AddSubMsgLst ($msg, $var);
}

sub Unregister {
    if (!$isWin) {
        return 1;
    }
    my ($self) = @_;
    my $path = $self->getPath () . $path_separator . "dotnetcore";
    my $var = new SDB::Install::System::EnvVariable ($envvar, $path);
    my $errlst = new SDB::Install::MsgLst ();
    my $msg = $self->AddMessage ("Removing " . $envvar . " environment variable");
    $var->{EnvVarExtend} = 'No';
    $var->{EnvVarType} = 'USER';
    if (isAdmin ()) {
        $var->{EnvVarType} = 'SYSTEM';
    }
    if (!defined $var->unset ()) {
        $self->AddError ("Failed to remove " . $envvar, $errlst);
    }
    $self->AddSubMsgLst ($msg, $var);
}

1;
