package BuildPackage::Worker;
use threads;
use threads::shared;
use Thread::Queue;
use Exporter;
use BuildPackage::Tools qw (deltree createTgz createInstallerPackage);
use SAPDB::Install::MD5Sum;
use strict;

our @ISA = qw (Exporter);

our @EXPORT = qw (startWorker endWorker pushTask waitForTasks);

BuildPackage::Tools::setErrMsgHandler(sub {print STDERR "ERROR: $_[0]\n"});
BuildPackage::Tools::setMsgHandler(sub {print "$_[0]\n"});

our $task_queue = new Thread::Queue ();
our $result_queue = new Thread::Queue ();
our @threads;
our $task_num :shared = 0;
our $thread_num = 0;

sub getThreadNum{
    return $thread_num;
}

sub worker{
	my ($tq,$rq) = @_;
	my @result;
	my $file;
	my $rc;
	my $gnutar;
    my $rootDir;
    my $fileName;
    my $filePath;
    my $tarFileList;
    my $cmd;
    my $task;
	while ($task = $tq->dequeue()){
		if ($task->[0] == 0){
			# md5 request
			${$task->[2]} = MD5Sum ($task->[1]);
			if (!${$task->[2]}){
				print STDERR "... Error, cannot get md5sum of  $task->[1]\n";
				$rq->enqueue (0);
				next;
			}
			$rq->enqueue (1);
		}
		elsif ($task->[0] == 2){
			# deltree request
			$rc = deltree ($task->[1]);
			if (!$rc){
				print STDERR "... Error, deleting tree '$task->[1]'\n";
				$rq->enqueue (1);
				next;
			}
			$rq->enqueue (1);
		}
		elsif ($task->[0] == 4){
            # create tgz request
            if (!defined createTgz ($task->[1],$task->[3], $task->[4])){
                print STDERR "... Error, creating $task->[2]\n";
                $rq->enqueue (0);
                next;
            }
            print "...OK, $task->[2] created.\n";
            if ($task->[3]){
                #
                # delete buildroot after successful package creation
                #
                $task->[0] = 2;
                $task->[1] = $task->[3];
                repushTask($task);
            }
            $rq->enqueue (1);
		}
		elsif ($task->[0] == 5){
            # create installer package request
            my $retcode = createInstallerPackage(
                $task->[1],      # $archive
                $task->[2],      # $pData
                $task->[3],      # $list
                $task->[4],      # $script
                $task->[5],      # $content
                $task->[6],      # $pmask
                $task->[7],      # $pigz
                $task->[8],      # $threads
                $task->[9]       # $pigzRsyncable
            );
            if (!$retcode){
                print STDERR "... Error, creating package $task->[10] ($task->[1])\n";
                $rq->enqueue (0);
                next;
            }
            print "...OK, package $task->[10] created.\n";
            $rq->enqueue (1);
		}
		else{
			# execute cmd request
			$cmd = $task->[1]; 
			$rc = system ($cmd);
			if ($rc == -1 || $rc >> 8 != 0){
				print STDERR "... Error, creating $task->[2]\n";
				$rq->enqueue (0);
				next;
			}
			print "...OK, $task->[2] created.\n";
			if ($task->[3]){
				#
				# delete buildroot after successful package creation
				#
				$task->[0] = 2;
				$task->[1] = $task->[3];
				repushTask($task);
			}
			$rq->enqueue (1);
		}
	}
	$rq->enqueue (undef);
}


sub startWorker{
	($thread_num) = @_;
	print "Starting $thread_num threads...\n";
	foreach my $i (0..$thread_num - 1){
		$threads[$i] = threads->create (\&worker, $task_queue, $result_queue);
	}
	return 1;
}

sub endWorker{
	print "Joining $thread_num threads...\n";
	foreach my $i (1..$thread_num){
		$task_queue->enqueue (undef);
	}
	
	my $finished = 0;
	while (my $result = $result_queue->dequeue ()){
		if (!defined $result){
			$finished++;
			if ($finished >= $thread_num){
				last;
			}
		}
	}
	
	foreach my $thread (@threads){
		$thread->join();
	}
	$thread_num = 0;
}


sub pushTask{
	my ($task) = @_;
	foreach my $i (0..(scalar (@$task) - 1)){
        if (ref ($task->[$i]) && ref ($task->[$i]) ne 'ARRAY'){
            share ($task->[$i]);
        }
    }
	my @copy : shared = @$task;
	$task_queue->enqueue (\@copy);
	$task_num++;
}

sub repushTask{
	$task_queue->enqueue ($_[0]);
	$task_num++;
}


sub waitForTasks{
	if (!$task_num){
		return 0;
	}
	my $finished = 0;
	my $errors = 0;
	my $result;
	while (1){
		$result = $result_queue->dequeue ();
		if ($result != 1){
			$errors++;
		}
		$finished++;
		if ($finished >= $task_num){
			last;
		}
	}
	$task_num = 0;
	return $errors;
}



1;
