package LCM::ActionsDetector::Action::RegisterRenameSystem;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub requiresExistingInstance {
    return 0;
}

sub getKey {
    my ($self) = @_;
    return 'RegisterRenameSystem';
}

sub getBatchKey {
    my ($self) = @_;
    return 'register_rename_system';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Register and Rename %s System", $self->_getProductName());
}

sub requiresRoot {
    return 1;
}

sub executeSpecificChecks {
    my ($self, $actionsManager) = @_;
    my $config = $actionsManager->getConfiguration();
    if ($config->isScopeInstance('hdblcm_rename_system')) {
        $self->_setNotApplicableReason('there is pending rename_system (scope instance). Please use --action=rename_system');
        return 0;
    }
    if ($actionsManager->getNumberOfHosts()) {
        $self->_setNotApplicableReason('the system is already registered');
        return 0;
    }
    if ($actionsManager->isHostPartOfSystem()) {
        $self->_setNotApplicableReason('this instance is already registered');
        return 0;
    }
    return 1;
}

1;