package LCM::ActionsDetector::Action::RemoveHosts;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub getKey {
    my ($self) = @_;
    return 'RemoveHosts';
}

sub getBatchKey {
    my ($self) = @_;
    return 'remove_hosts';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Remove Hosts from the %s System", $self->_getProductName());
}

sub executeSpecificChecks {
    my ($self, $actionsManager) = @_;
    if ($actionsManager->isHostPartOfSystem() && $actionsManager->getNumberOfHosts() < 2) {
        $self->_setNotApplicableReason('this is a single-host system');
        return 0;
    }
    return 1;
}

1;