package LCM::App::ConsoleUtils;

use strict;
use LCM::SummaryTreeBuilder;

use Exporter qw(import);

our @EXPORT_OK = qw(printSummary printPendingInfo printMsg);
our %EXPORT_TAGS = ( all => \@EXPORT_OK );

sub printSummary {
	my ( $summaryTree ) = @_;

    my $headline = 'Summary before execution:';
    print "\n$headline\n" . ('=' x length($headline)) . "\n\n";

	_printNode( $summaryTree, 0 );
}

sub printPendingInfo {
	my ( $summaryTree ) = @_;
	my $headline = 'Pending update information:';

	print "\n$headline\n" . ('=' x length($headline)) . "\n\n";
	_printNode( $summaryTree, 0 );
}

sub _printNode {
	my ( $nodeRef, $indent ) = @_;

	print " " x ( $indent * 3 ) . $nodeRef->{"text"} . "\n";
	my $childrenRef = $nodeRef->{"children"};
	if ( !defined $childrenRef ) {
		return;
	}
	foreach my $childRef ( @{$childrenRef} ) {
		_printNode ( $childRef, $indent + 1 );
	}
}

sub printMsg {
	my ($msg, $indent) = @_;
	my $application = LCM::App::ApplicationContext::getInstance()->getApplication();
	my $isGui = $application->isGUIApplication();
	print " " x ( $indent * 2 ) . $msg . "\n" if (!$isGui);
}

1;
